% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.CBA}
\alias{predict.CBA}
\alias{predict}
\alias{accuracy}
\title{Model Prediction for Classifiers Based on Association Rules}
\usage{
\method{predict}{CBA}(object, newdata, type = c("class", "score"), ...)

accuracy(pred, true)
}
\arguments{
\item{object}{An object of class \link{CBA}.}

\item{newdata}{A data.frame or \link[arules:transactions-class]{arules::transactions} containing rows of new entries
to be classified.}

\item{type}{Predict \code{"class"} labels. Some classifiers can also return
\code{"scores"}.}

\item{\dots}{Additional arguments are ignored.}

\item{pred, true}{two factors with the same level representing the predictions and the ground truth (e.g., obtrained with \code{\link[=response]{response()}}).}
}
\value{
A factor vector with the classification result.
}
\description{
Predicts classes for new data using a CBA classifier.
}
\examples{
data("iris")

train_id <- sample(seq_len(nrow(iris)), 130)
iris_train <- iris[train_id, ]
iris_test <- iris[-train_id, ]

cl <- CBA(Species ~., iris_train)
pr <- predict(cl, iris_test)
pr

accuracy(pr, response(Species ~., iris_test))
}
\author{
Michael Hahsler
}
