% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install-arrow.R
\name{install_arrow}
\alias{install_arrow}
\title{Install or upgrade the Arrow library}
\usage{
install_arrow(
  nightly = FALSE,
  binary = Sys.getenv("LIBARROW_BINARY", TRUE),
  use_system = Sys.getenv("ARROW_USE_PKG_CONFIG", FALSE),
  minimal = Sys.getenv("LIBARROW_MINIMAL", FALSE),
  verbose = Sys.getenv("ARROW_R_DEV", FALSE),
  repos = getOption("repos"),
  ...
)
}
\arguments{
\item{nightly}{logical: Should we install a development version of the
package, or should we install from CRAN (the default).}

\item{binary}{On Linux, value to set for the environment variable
\code{LIBARROW_BINARY}, which governs how C++ binaries are used, if at all.
The default value, \code{TRUE}, tells the installation script to detect the
Linux distribution and version and find an appropriate C++ library. \code{FALSE}
would tell the script not to retrieve a binary and instead build Arrow C++
from source. Other valid values are strings corresponding to a Linux
distribution-version, to override the value that would be detected.
See \code{vignette("install", package = "arrow")} for further details.}

\item{use_system}{logical: Should we use \code{pkg-config} to look for Arrow
system packages? Default is \code{FALSE}. If \code{TRUE}, source installation may be
faster, but there is a risk of version mismatch. This sets the
\code{ARROW_USE_PKG_CONFIG} environment variable.}

\item{minimal}{logical: If building from source, should we build without
optional dependencies (compression libraries, for example)? Default is
\code{FALSE}. This sets the \code{LIBARROW_MINIMAL} environment variable.}

\item{verbose}{logical: Print more debugging output when installing? Default
is \code{FALSE}. This sets the \code{ARROW_R_DEV} environment variable.}

\item{repos}{character vector of base URLs of the repositories to install
from (passed to \code{install.packages()})}

\item{...}{Additional arguments passed to \code{install.packages()}}
}
\description{
Use this function to install the latest release of \code{arrow}, to switch to or
from a nightly development version, or on Linux to try reinstalling with
all necessary C++ dependencies.
}
\details{
Note that, unlike packages like \code{tensorflow}, \code{blogdown}, and others that
require external dependencies, you do not need to run \code{install_arrow()}
after a successful \code{arrow} installation.
}
\seealso{
\code{\link[=arrow_info]{arrow_info()}} to see if the package was configured with
necessary C++ dependencies. \code{vignette("install", package = "arrow")} for
more ways to tune installation on Linux.
}
