% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feather.R
\name{read_feather}
\alias{read_feather}
\title{Read a Feather file}
\usage{
read_feather(file, col_select = NULL, as_data_frame = TRUE, ...)
}
\arguments{
\item{file}{A character file path, a raw vector, or \code{InputStream}, passed to
\code{FeatherTableReader$create()}.}

\item{col_select}{A character vector of column names to keep, as in the
"select" argument to \code{data.table::fread()}, or a
\link[tidyselect:vars_select]{tidy selection specification}
of columns, as used in \code{dplyr::select()}.}

\item{as_data_frame}{Should the function return a \code{data.frame} or an
\link[=Table]{arrow::Table}?}

\item{...}{additional parameters}
}
\value{
A \code{data.frame} if \code{as_data_frame} is \code{TRUE} (the default), or an
\link[=Table]{arrow::Table} otherwise
}
\description{
Read a Feather file
}
\examples{
\donttest{
try({
  tf <- tempfile()
  on.exit(unlink(tf))
  write_feather(iris, tf)
  df <- read_feather(tf)
  dim(df)
  # Can select columns
  df <- read_feather(tf, col_select = starts_with("Sepal"))
})
}
}
