% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/clean.R
\docType{methods}
\name{clean_whitespace}
\alias{clean_whitespace}
\alias{clean_whitespace-method}
\alias{clean_whitespace,data.frame-method}
\alias{clean_whitespace,matrix-method}
\title{Remove Leading/Trailing Whitespace}
\usage{
clean_whitespace(x, ...)

\S4method{clean_whitespace}{data.frame}(x, which = c("both", "left", "right"), squish = TRUE)

\S4method{clean_whitespace}{matrix}(x, which = c("both", "left", "right"), squish = TRUE)
}
\arguments{
\item{x}{An \R object (should be a \code{\link{matrix}} or a \code{\link{data.frame}}).}

\item{...}{Currently not used.}

\item{which}{A \code{\link{character}} string specifying whether to remove \code{both}
leading and trailing whitespace (default), or only leading ("\code{left}") or
trailing ("\code{right}").}

\item{squish}{A \code{\link{logical}} scalar: should all internal whitespace be
replaced with a single space?}
}
\description{
Remove Leading/Trailing Whitespace
}
\examples{
x <- data.frame(
  A = c("  Both ", "  Left", "Right  "),
  B = 1:3
)

clean_whitespace(x, which = "both")
clean_whitespace(x, which = "left")
clean_whitespace(x, which = "right")
}
\seealso{
\code{\link[=trimws]{trimws()}}

Other data cleaning tools: 
\code{\link{remove_Inf}()},
\code{\link{remove_NA}()},
\code{\link{remove_constant}()},
\code{\link{remove_empty}()},
\code{\link{remove_zero}()},
\code{\link{replace_Inf}()},
\code{\link{replace_NA}()},
\code{\link{replace_empty}()},
\code{\link{replace_zero}()}
}
\author{
N. Frerebeau
}
\concept{data cleaning tools}
