% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{label_auto}
\alias{label_auto}
\title{Non-Overlapping Text Labels}
\usage{
label_auto(
  x,
  y = NULL,
  ...,
  labels = seq_along(x),
  segment = FALSE,
  box = FALSE
)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector giving the x and y coordinates of a set of
points. If \code{y} is \code{NULL}, an attempt is made to interpret \code{x} in a suitable
way (see \code{\link[grDevices:xy.coords]{grDevices::xy.coords()}}).}

\item{...}{Further arguments to be passed to \code{\link[graphics:text]{graphics::text()}},
particularly, character expansion, \code{cex} and color, \code{col}.}

\item{labels}{A \code{\link{character}} vector or \code{\link{expression}} specifying the text
to be written.}

\item{segment}{A \code{\link{logical}} scalar: should segments be drawn?}

\item{box}{A \code{\link{logical}} scalar: should a box be drawn underneath labels?}
}
\value{
\code{label_auto()} is called it for its side-effects.
}
\description{
Optimize the location of text labels to minimize overplotting text.
}
\note{
For internal use only.
}
\seealso{
\code{\link[graphics:text]{graphics::text()}}

Other graphic tools: 
\code{\link{circle}()},
\code{\link{inch2line}()},
\code{\link{label_percent}()}
}
\author{
N. Frerebeau
}
\concept{graphic tools}
\keyword{internal}
