% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/discard.R, R/replace.R
\docType{methods}
\name{zero}
\alias{zero}
\alias{remove_zero}
\alias{remove_zero-method}
\alias{replace_zero}
\alias{replace_zero-method}
\alias{remove_zero,ANY-method}
\alias{replace_zero,matrix-method}
\title{Tools for working with zeros}
\usage{
remove_zero(x, ...)

replace_zero(x, ...)

\S4method{remove_zero}{ANY}(x, margin = 1, all = FALSE)

\S4method{replace_zero}{matrix}(x, value)
}
\arguments{
\item{x}{An object (should be a \code{\link{matrix}} or a \code{\link{data.frame}}).}

\item{...}{Currently not used.}

\item{margin}{A vector giving the subscripts which the function will be
applied over (\code{1} indicates rows, \code{2} indicates columns).}

\item{all}{A \code{\link{logical}} scalar. If \code{TRUE}, only the rows/columns whose
values all meet the condition defined by \code{f} are considered. If \code{FALSE}
(the default), only rows/columns where at least one value validates the
condition defined by \code{f} are considered.}

\item{value}{A possible replacement value.}
}
\description{
\itemize{
\item \code{remove_zero()} remove rows/columns that contain zeros.
\item \code{replace_zero} replaces zeros.
}
}
\examples{
## Create a count data matrix
X <- matrix(sample(1:10, 25, TRUE), nrow = 5, ncol = 5)

## Add NA
k <- sample(1:25, 3, FALSE)
X[k] <- NA
X

## Count missing values in rows
count(X, f = is.na, margin = 1)
## Count non-missing values in columns
count(X, f = is.na, margin = 2, negate = TRUE)

## Find row with NA
detect(X, f = is.na, margin = 1)
## Find column without any NA
detect(X, f = is.na, margin = 2, negate = TRUE, all = TRUE)

## Keep row without any NA
keep(X, f = is.na, margin = 1, negate = TRUE, all = TRUE)
## Keep row without any NA
keep(X, f = is.na, margin = 2, negate = TRUE, all = TRUE)

## Remove row with any NA
discard(X, f = is.na, margin = 1, all = FALSE)
## Remove column with any NA
discard(X, f = is.na, margin = 2, all = FALSE)

## Replace NA with zeros
replace_NA(X, value = 0)
}
\seealso{
Other data cleaning tools: 
\code{\link{compact}()},
\code{\link{count}()},
\code{\link{detect}()},
\code{\link{discard}()},
\code{\link{infinite}},
\code{\link{keep}()},
\code{\link{missing}}
}
\author{
N. Frerebeau
}
\concept{data cleaning tools}
