% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/replace.R
\docType{methods}
\name{replace_Inf}
\alias{replace_Inf}
\alias{replace_Inf-method}
\alias{replace_Inf,matrix-method}
\alias{replace_Inf,data.frame-method}
\title{Replace Infinite Values}
\usage{
replace_Inf(x, ...)

\S4method{replace_Inf}{matrix}(x, value = 0)

\S4method{replace_Inf}{data.frame}(x, value = 0)
}
\arguments{
\item{x}{An \R object (should be a \code{\link{matrix}} or a \code{\link{data.frame}}).}

\item{...}{Currently not used.}

\item{value}{A possible replacement value.}
}
\description{
Replaces \link[=is.finite]{infinite values} values.
}
\examples{
## Create a data matrix
X <- matrix(sample(1:10, 25, TRUE), nrow = 5, ncol = 5)

## Add Inf
k <- sample(1:25, 3, FALSE)
X[k] <- Inf
X

## Remove rows with Inf
remove_Inf(X, margin = 1)

## Replace Inf with zeros
replace_Inf(X, value = 0)
}
\seealso{
Other data cleaning tools: 
\code{\link{clean_whitespace}()},
\code{\link{remove_Inf}()},
\code{\link{remove_NA}()},
\code{\link{remove_constant}()},
\code{\link{remove_empty}()},
\code{\link{remove_zero}()},
\code{\link{replace_NA}()},
\code{\link{replace_empty}()},
\code{\link{replace_zero}()}
}
\author{
N. Frerebeau
}
\concept{data cleaning tools}
