% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predicates.R
\name{predicate-trend}
\alias{predicate-trend}
\alias{is_equal}
\alias{is_increasing}
\alias{is_decreasing}
\alias{is_overlapping}
\title{Numeric Trend Predicates}
\usage{
is_equal(x, tolerance = .Machine$double.eps^0.5, na.rm = TRUE)

is_increasing(x, na.rm = TRUE)

is_decreasing(x, na.rm = TRUE)

is_overlapping(x, y)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} object to be tested.}

\item{tolerance}{A \code{\link{numeric}} scalar giving the
tolerance to check within.}

\item{na.rm}{A \code{\link{logical}} scalar: should missing values
(including \code{NaN}) be omitted?}
}
\value{
A \code{\link{logical}} scalar.
}
\description{
Check numeric objects:
}
\details{
\code{is_equal} checks for equality among all elements of a vector.

\code{is_increasing} and \code{is_decreasing} check if a sequence of numbers
is monotonically increasing or decreasing, respectively.

\code{is_overlapping} checks if two data ranges overlap at all.
}
\seealso{
Other predicates: 
\code{\link{predicate-graph}},
\code{\link{predicate-matrix}},
\code{\link{predicate-numeric}},
\code{\link{predicate-scalar}},
\code{\link{predicate-type}},
\code{\link{predicate-utils}}
}
\concept{predicates}
\keyword{internal}
