% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aricode.R
\name{clustComp}
\alias{clustComp}
\title{measures of similarity between two classification}
\usage{
clustComp(c1, c2)
}
\arguments{
\item{c1}{a vector containing the labels of the first classification. Must be a vector of characters, integers, numerics, or a factor, but not a list.}

\item{c2}{a vector containing the labels of the second classification.}
}
\value{
a list with the RI, ARI, NMI, NVI and NID.
}
\description{
A function various measures of similarity between two classifications
}
\examples{
data(iris)
cl <- cutree(hclust(dist(iris[,-5])), 4)
clustComp(cl,iris$Species)
}
\seealso{
\code{\link{RI}}, \code{\link{NID}}, \code{\link{NVI}}, \code{\link{NMI}}, \code{\link{ARI}}
}
