% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw_as_char.r
\name{raw_as_char}
\alias{raw_as_char}
\title{raw_as_char}
\usage{
raw_as_char(raw, upper = TRUE, spaces = FALSE)
}
\arguments{
\item{raw}{A raw vector.}

\item{upper}{Should hex digits A-F be given in uppercase?}

\item{spaces}{Should the str use spaces?}
}
\value{
A character string.
}
\description{
Convert the literal bytes of a raw (unsigned char*) to a
string representation.  This is different from R's
\code{rawToChar()}.  See examples for details.
}
\examples{
\dontrun{
library(argon2)
str <- "some text"
raw <- charToRaw(str)
raw

rawToChar(raw)
raw_as_char(raw)
}

}
