% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarized.R
\name{buyer_details}
\alias{buyer_details}
\title{Get monthly summarized pill totals by county}
\usage{
buyer_details(county = "Mingo", state = "WV", key = "WaPo")
}
\arguments{
\item{county}{Filter the data to only this county (e.g. 'Mingo')}

\item{state}{Filter the data to county within this state (e.g. 'WV')}

\item{key}{Key needed to make query successful}
}
\description{
Get monthly summarized pill totals by county
}
\examples{
\donttest{
library(arcos)

mingo_wv <- buyer_details(county = "Mingo", state="WV", key="WaPo")

head(mingo_wv)
}
}
\seealso{
\url{https://www.washingtonpost.com/graphics/2019/investigations/dea-pain-pill-database/#download-resources}

Other summarized: \code{\link{combined_buyer_annual}},
  \code{\link{combined_buyer_monthly}},
  \code{\link{summarized_county_annual}},
  \code{\link{summarized_county_monthly}},
  \code{\link{total_distributors_county}},
  \code{\link{total_distributors_state}},
  \code{\link{total_manufacturers_county}},
  \code{\link{total_manufacturers_state}},
  \code{\link{total_pharmacies_county}},
  \code{\link{total_pharmacies_state}}
}
\concept{summarized}
