% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinySearchInLocalRepo.R
\name{shinySearchInLocalRepo}
\alias{shinySearchInLocalRepo}
\title{Shiny Based Live Search for an Artifact in a Repository Using Tags}
\usage{
shinySearchInLocalRepo(repoDir = NULL, host = "0.0.0.0")
}
\arguments{
\item{repoDir}{A character denoting an existing directory in which artifacts will be searched.
If set to \code{NULL} (by default), uses the \code{repoDir} specified in \link{setLocalRepo}.}

\item{host}{A host IP adress, see the \code{host} argument in \code{shiny::runApp}.}
}
\value{
\code{shinySearchInLocalRepo} runs a shiny application.
}
\description{
\code{shinySearchInLocalRepo} searches for an artifact in a \link{Repository} using \link{Tags}.
To create an application one needs to point the name of artifacts' repository.
The application is generated on the run. As for now there are two controllers exposed. 
A text input field and a slider. Tags that are typed into text field are used for searching in repository. 
Objects that have the same Tags are presented on the right panel.
These object might be also downloaded just by click.
To learn more about artifacts visit \link[archivist]{archivist-package}.
}
\details{
\code{shinySearchInLocalRepo} searches for artifacts in a Repository using their \code{Tags} 
(e.g., \code{name}, \code{class} or \code{archiving date}). \code{Tags} are submitted in a 
text input in a shiny application. Many Tags may be specified, they should be comma separated. 
User can specify more Tags like phase, project, author etc. when artifact is created.

In the search query one can add Tags starting with \code{sort:} or \code{sort:-}.
As a result, miniatures will be sorted appropriately.
For example \code{sort:class} will sort \code{class} Tags, while \code{sort:-class} will
sort \code{class} tags backwards. \code{sort:createdDate} will sort \code{createdDate} Tag and
\code{sort:-createdDate} will sort \code{createdDate} Tag backwards.

\code{Tags}, submitted in the text field, should be given according to the 
format: \code{"TagKey:TagValue"} - see examples.
}
\section{Contact}{

 
Bug reports and feature requests can be sent to 
\href{https://github.com/pbiecek/archivist/issues}{https://github.com/pbiecek/archivist/issues}
}

\section{shiny}{


This function use tools from the fantastic \pkg{shiny}
package, so you'll need to make sure to have it installed.
}

\examples{
\dontrun{
  # assuming that there is a 'repo' dir with a valid archivist repository
  shinySearchInLocalRepo( repoDir = 'repo' )
}
}
\references{
Biecek P and Kosinski M (2017). "archivist: An R Package for Managing,
Recording and Restoring Data Analysis Results." _Journal of Statistical
Software_, *82*(11), pp. 1-28. doi: 10.18637/jss.v082.i11 (URL:
http://doi.org/10.18637/jss.v082.i11).
URL https://github.com/pbiecek/archivist
}
\seealso{
Other archivist: 
\code{\link{Repository}},
\code{\link{Tags}},
\code{\link{\%a\%}()},
\code{\link{addHooksToPrint}()},
\code{\link{addTagsRepo}()},
\code{\link{aformat}()},
\code{\link{ahistory}()},
\code{\link{alink}()},
\code{\link{aoptions}()},
\code{\link{archivist-package}},
\code{\link{areadLocal}()},
\code{\link{aread}()},
\code{\link{asearchLocal}()},
\code{\link{asearch}()},
\code{\link{asession}()},
\code{\link{atrace}()},
\code{\link{cache}()},
\code{\link{copyLocalRepo}()},
\code{\link{createLocalRepo}()},
\code{\link{createMDGallery}()},
\code{\link{deleteLocalRepo}()},
\code{\link{getRemoteHook}()},
\code{\link{getTagsLocal}()},
\code{\link{loadFromLocalRepo}()},
\code{\link{md5hash}},
\code{\link{removeTagsRepo}()},
\code{\link{restoreLibs}()},
\code{\link{rmFromLocalRepo}()},
\code{\link{saveToLocalRepo}()},
\code{\link{searchInLocalRepo}()},
\code{\link{setLocalRepo}()},
\code{\link{showLocalRepo}()},
\code{\link{splitTagsLocal}()},
\code{\link{summaryLocalRepo}()},
\code{\link{zipLocalRepo}()}
}
\author{
Przemyslaw Biecek, \email{przemyslaw.biecek@gmail.com}
}
\concept{archivist}
