% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alink.R
\name{alink}
\alias{alink}
\title{Return a Link To Download an Artifact Stored on Remote Repository}
\usage{
alink(md5hash, repo = aoptions("repo"), user = aoptions("user"),
  subdir = aoptions("subdir"), branch = "master",
  repoType = aoptions("repoType"), format = "markdown", rawLink = FALSE)
}
\arguments{
\item{md5hash}{A character assigned to the artifact through the use of a cryptographical hash function with MD5 algorithm. 
If it is specified in a format of \code{'repo/user/md5hash'} then \code{user} and \code{repo} parameters are omitted.}

\item{repo}{The Remote \code{Repository} on which the artifact that we want to download
is stored.}

\item{user}{The name of a user on whose \code{Repository} the the artifact that we want to download
is stored.}

\item{subdir}{A character containing a name of a directory on the Remote repository 
on which the Repository is stored. If the Repository is stored in the main folder on the Remote repository, this should be set 
to \code{subdir = "/"} as default.}

\item{branch}{A character containing a name of the Remote Repository's branch
on which the Repository is archived. Default \code{branch} is \code{master}.}

\item{repoType}{A character containing a type of the remote repository. Currently it can be 'github' or 'bitbucket'.}

\item{format}{In which format the link should be returned. Possibilites are \code{markdown} (default) or \code{latex}.}

\item{rawLink}{A logical denoting whether to return raw link or a link in the \code{format} convention. 
Default value is \code{FALSE}.}
}
\value{
This function returns a link to download artifact that is archived on GitHub.
}
\description{
\code{alink} returns a link to download an artifact from the Remote \link{Repository}.
Artifact has to be already archived on GitHub, e.g with \code{archivist.github::archive} function (recommended) or 
\link{saveToRepo} function and traditional Git manual synchronization.
To learn more about artifacts visit \link[archivist]{archivist-package}.
}
\details{
For more information about \code{md5hash} see \link{md5hash}.
}
\note{
Bug reports and feature requests can be sent to \href{https://github.com/pbiecek/archivist/issues}{https://github.com/pbiecek/archivist/issues}
}
\examples{
# link in markdown format
alink('pbiecek/archivist/134ecbbe2a8814d98f0c2758000c408e')
# link in markdown format with additional subdir
alink(user='BetaAndBit',repo='PieczaraPietraszki',
     md5hash = '1569cc44e8450439ac52c11ccac35138', 
     subdir = 'UniwersytetDzieci/arepo')
# link in latex format
alink(user = 'MarcinKosinski', repo = 'Museum',
      md5hash = '1651caa499a2b07a3bdad3896a2fc717', format = 'latex')
# link in raw format
alink('pbiecek/graphGallery/f5185c458bff721f0faa8e1332f01e0f', rawLink = TRUE)  
alink('pbiecek/graphgallerygit/02af4f99e440324b9e329faa293a9394', repoType='bitbucket')  
}
\author{
Marcin Kosinski, \email{m.p.kosinski@gmail.com}
}
\seealso{
Other archivist: \code{\link{Repository}},
  \code{\link{Tags}}, \code{\link{\%a\%}},
  \code{\link{addHooksToPrint}}, \code{\link{addTagsRepo}},
  \code{\link{aformat}}, \code{\link{ahistory}},
  \code{\link{aoptions}}, \code{\link{archivist-package}},
  \code{\link{aread}}, \code{\link{asearch}},
  \code{\link{asession}}, \code{\link{atrace}},
  \code{\link{cache}}, \code{\link{copyLocalRepo}},
  \code{\link{createLocalRepo}},
  \code{\link{createMDGallery}},
  \code{\link{deleteLocalRepo}},
  \code{\link{getRemoteHook}}, \code{\link{getTagsLocal}},
  \code{\link{loadFromLocalRepo}}, \code{\link{md5hash}},
  \code{\link{restoreLibs}}, \code{\link{rmFromLocalRepo}},
  \code{\link{saveToLocalRepo}},
  \code{\link{searchInLocalRepo}},
  \code{\link{setLocalRepo}},
  \code{\link{shinySearchInLocalRepo}},
  \code{\link{showLocalRepo}},
  \code{\link{splitTagsLocal}},
  \code{\link{summaryLocalRepo}},
  \code{\link{zipLocalRepo}}
}

