% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restoreLibraries.R
\name{restoreLibs}
\alias{restoreLibs}
\title{Restore Versions of Libraries}
\usage{
restoreLibs(md5hash, session_info = NULL)
}
\arguments{
\item{md5hash}{One of the following (see \link{aread}):

A character vector which elements are consisting of at least three components separated 
with '/': Remote user name, Remote repository and name of the artifact (MD5 hash) or 
it's abbreviation.

MD5 hashes of artifacts in current local default directory or its abbreviations.}

\item{session_info}{Object with versions of packages to be installed. If not supplied then 
it will be extracted from md5hash \code{ md5hash }}
}
\description{
Function \code{ restoreLibs } gets either \code{session info} or artifact's \code{md5hash} 
and restore libraries/packages to versions attached when the object was saved in the repo. 
Typical use case is following. We have saved an object and now we are restoring it, but
with current version of packages something is not working. The function \code{restoreLibs()} 
reverts all libraries that were attached previously to their previous versions.
}
\examples{
\dontrun{
## objects preparation
restoreLibs(md5hash = "pbiecek/graphGallery/f05f0ed0662fe01850ec1b928830ef32")
}
}
\author{
Marcin Kosinski, \email{m.p.kosinski@gmail.com}
Przemyslaw Biecek, \email{przemyslaw.biecek@gmail.com}
}
\seealso{
Other archivist: \code{\link{Repository}},
  \code{\link{Tags}}, \code{\link{\%a\%}},
  \code{\link{addHooksToPrint}}, \code{\link{addTagsRepo}},
  \code{\link{aformat}}, \code{\link{ahistory}},
  \code{\link{alink}}, \code{\link{aoptions}},
  \code{\link{archivist-package}}, \code{\link{aread}},
  \code{\link{asearch}}, \code{\link{asession}},
  \code{\link{cache}}, \code{\link{copyLocalRepo}},
  \code{\link{createLocalRepo}},
  \code{\link{createMDGallery}},
  \code{\link{deleteLocalRepo}},
  \code{\link{getRemoteHook}}, \code{\link{getTagsLocal}},
  \code{\link{loadFromLocalRepo}}, \code{\link{md5hash}},
  \code{\link{rmFromLocalRepo}},
  \code{\link{saveToLocalRepo}},
  \code{\link{searchInLocalRepo}},
  \code{\link{setLocalRepo}},
  \code{\link{shinySearchInLocalRepo}},
  \code{\link{showLocalRepo}},
  \code{\link{splitTagsLocal}},
  \code{\link{summaryLocalRepo}},
  \code{\link{zipLocalRepo}}
}

