% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asearch.R
\name{asearch}
\alias{asearch}
\title{Read Artifacts Given as a List of Tags}
\usage{
asearch(patterns, repo = NULL)
}
\arguments{
\item{patterns}{A character vector of \code{Tags}. Only artifacts that 
contain all Tags are returned.}

\item{repo}{One of following:

A character with Remote user name and Remote repository name separated by `/`.

NULL in this case search will be performed in the default repo, either local or Remote}
}
\value{
This function returns a list of artifacts (by their values).
}
\description{
\code{asearch} searches for artifacts that contain all specified \link{Tags}
and reads all of them from a default or Remote \link{Repository}. It's a wrapper around 
\link{searchInLocalRepo} and \link{loadFromLocalRepo} and their Remote versions.
}
\details{
Function \code{asearch} reads all artifacts that contain given list of \code{Tags}
from default or Remote Repository.
It uses both \link{loadFromLocalRepo} and \link{searchInLocalRepo} functions (or their Remote versions)
but has shorter name and different parameter's specification.
}
\note{
Remember that if you want to use local repository you should set it to default.
}
\examples{
\dontrun{
### default LOCAL version
## objects preparation

# data.frame object
data(iris)

# ggplot/gg object
library(ggplot2)
df <- data.frame(gp = factor(rep(letters[1:3], each = 10)),y = rnorm(30))
library(plyr)
ds <- ddply(df, .(gp), summarise, mean = mean(y), sd = sd(y))
myplot123 <- ggplot(df, aes(x = gp, y = y)) +
  geom_point() +  geom_point(data = ds, aes(y = mean),
                             colour = 'red', size = 3)

# lm object
model <- lm(Sepal.Length~ Sepal.Width + Petal.Length + Petal.Width, data= iris)
model2 <- lm(Sepal.Length~ Sepal.Width + Petal.Width, data= iris)
model3 <- lm(Sepal.Length~ Sepal.Width, data= iris)

## creating example default local repository
exampleRepoDir <- tempfile()
createLocalRepo(repoDir = exampleRepoDir)
## setting default local repository
setLocalRepo( repoDir = exampleRepoDir )

saveToLocalRepo(myplot123)
saveToLocalRepo(iris)
saveToLocalRepo(model)
saveToLocalRepo(model2)
saveToLocalRepo(model3)

## Searching for objects of class:lm
lm <- asearch(patterns = "class:lm")

## Searching for objects of class:lm with coefname:Petal.Width
lm_c_PW <- asearch(patterns = c("class:lm","coefname:Petal.Width"))

# Note that we searched for objects. Then loaded them from repository by their value.


## deleting example repository
deleteLocalRepo(repoDir = exampleRepoDir, deleteRoot = TRUE)
rm(exampleRepoDir)

### default GitHub version
## Setting default github repository
setRemoteRepo( user = "pbiecek", repo = "archivist")

showRemoteRepo(method = "tags")$tag
searchInRemoteRepo(pattern = "class:lm")
searchInRemoteRepo(pattern = "class:gg")
getTagsRemote(md5hash = "cd6557c6163a6f9800f308f343e75e72", tag = "")

## Searching for objects of class:lm
asearch(patterns = c("class:lm"))
## Searching for objects of class:gg
asearch(patterns = c("class:gg"))

### Remote version 
## Note that repo argument is passed in the following way to asearch:
## repo = "GitHub user name/GitHub repository name"

## Searching for objects of class:gg
asearch("pbiecek/graphGallery", 
        patterns = c("class:gg",
                     "labelx:Sepal.Length"))
}
}
\author{
Przemyslaw Biecek, \email{przemyslaw.biecek@gmail.com}
}
\seealso{
Other archivist: \code{\link{Repository}},
  \code{\link{Tags}}, \code{\link{\%a\%}},
  \code{\link{addHooksToPrint}}, \code{\link{addTagsRepo}},
  \code{\link{aformat}}, \code{\link{ahistory}},
  \code{\link{alink}}, \code{\link{aoptions}},
  \code{\link{archivist-package}}, \code{\link{aread}},
  \code{\link{asession}}, \code{\link{cache}},
  \code{\link{copyLocalRepo}},
  \code{\link{createLocalRepo}},
  \code{\link{createMDGallery}},
  \code{\link{deleteLocalRepo}},
  \code{\link{getRemoteHook}}, \code{\link{getTagsLocal}},
  \code{\link{loadFromLocalRepo}}, \code{\link{md5hash}},
  \code{\link{restoreLibs}}, \code{\link{rmFromLocalRepo}},
  \code{\link{saveToLocalRepo}},
  \code{\link{searchInLocalRepo}},
  \code{\link{setLocalRepo}},
  \code{\link{shinySearchInLocalRepo}},
  \code{\link{showLocalRepo}},
  \code{\link{splitTagsLocal}},
  \code{\link{summaryLocalRepo}},
  \code{\link{zipLocalRepo}}
}

