% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/magrittr.R
\name{\%a\%}
\alias{\%a\%}
\title{magrittr - a forward-pipe operator for R}
\usage{
lhs \%a\% rhs
}
\arguments{
\item{lhs}{A dataset and function to apply to it.}

\item{rhs}{A dataset and function to apply to it.}
}
\description{
An extended pipe operator \link[magrittr]{\%>\%} from magrittr package version 1.0.1.
Enables archiving artifacts with their chaining code - see examples and vignettes.

The extension works as following, the result of %a% operator is archived together
with lhs (as an artifact) and rhs (as a tag). This allows to present a history of
an artifact. This option works only if a default repo is set.
}
\examples{
\dontrun{
iris \%a\% summary()

# Archiving artifacts with their chaining code

library(dplyr)
exampleRepoDir <- getwd()
createEmptyRepo( exampleRepoDir )

data("hflights", package = "hflights")
hflights \%a\%
  group_by(Year, Month, DayofMonth) \%a\%
  select(Year:DayofMonth, ArrDelay, DepDelay) \%a\%
  summarise(
    arr = mean(ArrDelay, na.rm = TRUE),
    dep = mean(DepDelay, na.rm = TRUE)
  ) \%a\%
  filter(arr > 30 | dep > 30) \%a\%
  saveToRepo( exampleRepoDir )
showLocalRepo(getwd())

}
}
\seealso{
Other archivist: \code{\link{Repository}};
  \code{\link{Tags}}; \code{\link{addTagsRepo}};
  \code{\link{ahistory}}, \code{\link{print.ahistory}};
  \code{\link{aoptions}}; \code{\link{archivist-package}};
  \code{\link{aread}}; \code{\link{asearch}};
  \code{\link{cache}}; \code{\link{copyGithubRepo}},
  \code{\link{copyLocalRepo}};
  \code{\link{createEmptyRepo}}; \code{\link{deleteRepo}};
  \code{\link{getTagsGithub}}, \code{\link{getTagsLocal}};
  \code{\link{loadFromGithubRepo}},
  \code{\link{loadFromLocalRepo}}; \code{\link{md5hash}};
  \code{\link{multiSearchInGithubRepo}},
  \code{\link{multiSearchInLocalRepo}},
  \code{\link{searchInGithubRepo}},
  \code{\link{searchInLocalRepo}};
  \code{\link{rmFromRepo}}; \code{\link{saveSetToRepo}};
  \code{\link{saveToRepo}}; \code{\link{setGithubRepo}},
  \code{\link{setLocalRepo}};
  \code{\link{shinySearchInLocalRepo}};
  \code{\link{showGithubRepo}},
  \code{\link{showLocalRepo}};
  \code{\link{summaryGithubRepo}},
  \code{\link{summaryLocalRepo}};
  \code{\link{zipGithubRepo}}, \code{\link{zipLocalRepo}}
}

