% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature-collection.R
\name{as_layer}
\alias{as_layer}
\alias{as_layer_definition}
\alias{as_feature_collection}
\title{Create Esri layer objects}
\usage{
as_layer(
  x,
  name,
  title,
  layer_definition = as_layer_definition(x, name, "object_id", infer_esri_type(x)),
  id = NULL,
  layer_url = NULL,
  legend_url = NULL,
  popup_info = NULL
)

as_layer_definition(
  x,
  name,
  object_id_field,
  fields = infer_esri_type(x),
  display_field = NULL,
  drawing_info = NULL,
  has_attachments = FALSE,
  max_scale = 0,
  min_scale = 0,
  templates = NULL,
  type_id_field = NULL,
  types = NULL
)

as_feature_collection(layers = list(), show_legend = TRUE)
}
\arguments{
\item{x}{an object of class \code{data.frame}. This can be an \code{sf} object or \code{tibble} or
any other subclass of \code{data.frame}.}

\item{name}{a scalar character of the name of the layer. Must be unique.}

\item{title}{A user-friendly string title for the layer that can be used in
a table of contents.}

\item{layer_definition}{a layer definition list as created by \code{as_layer_definition()}.
A default is derived from \code{x} and the \code{name} object.}

\item{id}{A number indicating the index position of the layer in the WMS or map service.}

\item{layer_url}{default \code{NULL}. A string URL to a service that should be used for all queries
against the layer. Used with hosted tiled map services on ArcGIS Online when
there is an associated feature service that allows for queries.}

\item{legend_url}{default \code{NULL}. A string URL to a legend graphic for the layer.
Used with WMS layers. The URL usually contains a GetLegendGraphic request.}

\item{popup_info}{default \code{NULL}. A list that can be converted into a
\href{https://developers.arcgis.com/documentation/common-data-types/popupinfo.htm}{popupInfo}
object defining the pop-up window content for the layer. There is no helper for
popupInfo objects.}

\item{object_id_field}{a scalar character vector indicating the name of the
object ID field in the dataset.}

\item{fields}{a data.frame describing the fields in \code{x}. These values are inferred
by default via \code{\link[=infer_esri_type]{infer_esri_type()}}.}

\item{display_field}{default \code{NULL}. A scalar character containing the name of the field that
best summarizes the feature. Values from this field are used by default as
the titles for pop-up windows.}

\item{drawing_info}{default \code{NULL}. See REST documentation in details for more.
There are no helpers or validators for \code{drawingInfo} objects.}

\item{has_attachments}{default \code{FALSE}.}

\item{max_scale}{default \code{NULL}. A number representing the maximum scale at
which the layer definition will be applied. The number is the scale's
denominator; thus, a value of 2400 represents a scale of 1/2,400. A value
of 0 indicates that the layer definition will be applied regardless of
how far you zoom in.}

\item{min_scale}{default \code{NULL}. A number representing the minimum scale at which the layer definition will be applied.}

\item{templates}{default \code{NULL}. See REST documentation in details for more.}

\item{type_id_field}{default \code{NULL}. See REST documentation in details for more.}

\item{types}{An array of type objects available for the dataset.
This is used when the \code{type_id_field} is populated. NOTE there are no
helper functions to create type objects. Any type list objects must match the
json structure when passed to \code{jsonify::to_json(x, unbox = TRUE)}.}

\item{layers}{a list of layers as created by \code{as_layer()}.}

\item{show_legend}{default \code{FALSE}. Logical scalar indicating if this layer
should be shown in the legend in client applications.}
}
\value{
A list object containing the required fields for each respective json type.
The results can be converted to json using \code{jsonify::to_json(x, unbox = TRUE)}
}
\description{
These functions are used to generate list objects that can be converted into
json objects that are used in REST API requests. Notably they are used for adding
R objects as items to a portal.
}
\details{
A \code{featureCollection} defines a layer of features that will be stored on a web map.
It consists of an array of \code{layer}s. The \code{layer} contains the features
(attributes and geometries) as a \code{featureSet} (see \code{\link[=as_featureset]{as_featureset()}}) and
additional metadata which is stored in the \code{layerDefinition}object. The
\code{layerDefinition} most importantly documents the fields in the object, the object ID,
and additional metadata such as name, title, and display scale.

Additional documentation for these json object:
\itemize{
\item \href{https://developers.arcgis.com/documentation/common-data-types/layer.htm}{\code{layer}}
\item \href{https://developers.arcgis.com/documentation/common-data-types/layerdefinition.htm}{\code{layerDefinition}}
\item \href{https://developers.arcgis.com/documentation/common-data-types/featurecollection.htm}{\code{featureCollection}}
}
}
\examples{
ld <- as_layer_definition(iris, "iris", "objectID")
l <- as_layer(iris, "iris name", "Iris Title")
fc <- as_feature_collection(layers = list(l))
}
\seealso{
\code{\link[=as_featureset]{as_featureset()}}
}
