% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{clear_query}
\alias{clear_query}
\alias{list_fields}
\alias{list_items}
\alias{refresh_layer}
\title{Utility functions}
\usage{
clear_query(x)

list_fields(x)

list_items(x)

refresh_layer(x)
}
\arguments{
\item{x}{an object of class \code{FeatureLayer}, \code{Table}, or \code{ImageServer}.}
}
\value{
See Details.
}
\description{
Utility functions
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
\itemize{
\item \code{list_fields()} returns a data.frame of the fields in a \code{FeatureLayer} or \code{Table}
\item \code{list_items()} returns a data.frame containing the layers or tables in a \code{FeatureServer} or \code{MapServer}
\item \code{clear_query()} removes any saved query in a \code{FeatureLayer} or \code{Table} object
\item \code{refresh_layer()} syncs a \code{FeatureLayer} or \code{Table} with the remote
resource picking up any changes that may have been made upstream.
Returns an object of class \code{x}.
}
}
\examples{
\dontrun{
  furl <- paste0(
    "https://services3.arcgis.com/ZvidGQkLaDJxRSJ2/arcgis/rest/services/",
    "PLACES_LocalData_for_BetterHealth/FeatureServer/0"
  )

  flayer <- arc_open(furl)

  # list fields available in a layer
  list_fields(flayer)

  # remove any queries stored in the query attribute
  clear_query(update_params(flayer, outFields = "*"))

  # refresh metadata of an object
  refresh_layer(flayer)

  map_url <- paste0(
    "https://services.arcgisonline.com/ArcGIS/rest/services/",
    "World_Imagery/MapServer"
  )

  # list all items in a server object
  list_items(arc_open(map_url))

}
}
