% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_apsim_met.R
\name{summary.met}
\alias{summary.met}
\title{Summary for an APSIM met file}
\usage{
\method{summary}{met}(
  object,
  ...,
  years,
  months,
  days,
  julian.days,
  compute.frost = FALSE,
  frost.temperature = 0,
  check = FALSE,
  verbose = FALSE,
  na.rm = FALSE,
  digits = 2
)
}
\arguments{
\item{object}{object of class \sQuote{met}}

\item{...}{optional argument (none used at the momemt)}

\item{years}{optional argument to subset years}

\item{months}{optional argument to subset by months. If an integer, it should
be between 1 and 12. If a character, it can be in the format, for example, 
\sQuote{jan} or \sQuote{Jan}.}

\item{days}{optional argument to subset by days. It should be an integer
between 1 and 31.}

\item{julian.days}{optional argument to subset by julian days. It
should be a vector of integers between 1 and 365. Either use \sQuote{days} or
\sQuote{julian.days} but not both.}

\item{compute.frost}{logical (default FALSE). Whether to compute
frost statistics.}

\item{frost.temperature}{value to use for the calculation of the frost 
period (default is zero).}

\item{check}{logical (default FALSE). Whether to \sQuote{check} the \sQuote{met} object.}

\item{verbose}{whether to print additional infomation to the console}

\item{na.rm}{whether to remove missing values. Passed to \sQuote{aggregate}}

\item{digits}{digits for rounding (default is 2).}
}
\value{
an object of class \sQuote{data.frame} with attributes
}
\description{
Create a data.frame summarizing an object of class \sQuote{met}
}
\details{
The frost free period is computed by first spliting each year (or year interval)
in two halves. The first and last frosts in the first and second period are found.
For the Northern hemisphere calendar days are used (1-365).
For the Southern hemisphere the year is split in two halfs, but the second half of
the year is used as the first part of the growing season.
If frost is not found a zero is returned.
}
\examples{

extd.dir <- system.file("extdata", package = "apsimx")
ames <- read_apsim_met("Ames.met", src.dir = extd.dir)

summary(ames, years = 2014:2016)

}
