% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sens_apsim.R
\name{sens_apsim}
\alias{sens_apsim}
\title{Sensitivity Analysis for APSIM Next Generation simulation}
\usage{
sens_apsim(
  file,
  src.dir = ".",
  crop.file,
  parm.paths,
  parm.vector.index,
  xml.parm,
  grid,
  summary = c("mean", "max", "var", "sd", "none"),
  root,
  verbose = TRUE,
  cores = 1L,
  save,
  ...
)
}
\arguments{
\item{file}{file name to be run (with extension .apsim)}

\item{src.dir}{directory containing the .apsim file to be run (defaults to the current directory)}

\item{crop.file}{name of auxiliary xml file where parameters are stored. If this is missing, it is 
assumed that the parameters to be edited are in the main simulation file.}

\item{parm.paths}{absolute or relative paths of the coefficients to be evaluated. 
It is recommended that you use \code{\link{inspect_apsim}} for this}

\item{parm.vector.index}{Index to evaluate a specific element of a parameter vector.  At the moment it is
possible to only edit one element at a time. This is because there is a conflict when generating multiple
elements in the candidate vector for the same parameter.}

\item{xml.parm}{TRUE or FALSE for each parameter. Indicating whether it is part of 
an xml file. Its length should be equal to the length or \sQuote{parm.paths}.}

\item{grid}{grid of parameter values for the evaluation. It can be a data.frame.}

\item{summary}{function name to use to summarize the output to be a sinlge row (default is the mean).}

\item{root}{root argument for \code{\link{edit_apsim}}}

\item{verbose}{whether to print progress in percent and elapsed time.}

\item{cores}{number of cores to use for parallel evaluation}

\item{save}{whether to save intermediate results. By default they will be saved as a
\sQuote{csv} file using the name of the apsim file. This will replace \sQuote{apsim} with \sQuote{csv}.
It is also possible to provide the file name here (for example: \sQuote{Some_results.csv}).}

\item{...}{additional arguments (none used at the moment).}
}
\value{
object of class \sQuote{sens_apsim}, but really just a list with results from the evaluations.
}
\description{
It is a wrapper for running APSIM and evaluating different parameters values
}
\note{
The summary function is stored as an attribute of the data frame \sQuote{grid.sims}.
}
\examples{
\donttest{
## See the vignette for examples
}

}
