% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/emulateAPSIM.R
\name{apsim_emul_sa}
\alias{apsim_emul_sa}
\title{Emulator-Based Sensitivity Analysis}
\usage{
apsim_emul_sa(model, X, boot = 1000, conf = 0.95, y = NULL, method, ...)
}
\arguments{
\item{model}{a function that specifies the model of interest}

\item{X}{n-by-p matrix of input values; n runs, p inputs}

\item{boot}{number of bootstrap replicates}

\item{conf}{confidence level of bootstrap calibrated intervals}

\item{y}{optional vector of model evaluations that can be used in place of the model statement}

\item{method}{method to use to emulate the model; \code{"singleGAM"} or \code{"separateGAM"}}

\item{...}{additional arguments passed to \code{method}}
}
\value{
A data frame of sensitivity measures where the exact form depends on the method, see details.
}
\description{
This is a generic function that can be used to estimate the sensitivity
indices for complex computer models using GAM-based emulators.
}
\details{
Each column of the matrix \code{X} corresponds to a different input and each row corresponds to a
different run of the computer model. Currently the method choices are: \code{"singleGAM"} and
\code{"separateGAM"}.  The \code{"singleGAM"} method builds a single generalized additive model (GAM)
with terms for all main
effects of inputs plus all two-way interactions between inputs. With this method all first-order
and total sensitivity indices are estimable provided at least 8p^2-4p+1 runs of the computer
model are available where p is the number of parameters considered.
The \code{"separateGAM"} method builds a separate GAM emulator for each
input to estimate first-order indices for each input.  Since this method emulates the marginal
distribution of \code{y} given each of the inputs, total order indices cannot be computed.  Both
methods can be bootstrapped in order to estimate standard errors and to calibrate confidence
regions for the sensitivity index estimates.  The argument \code{boot} specifies the number
of bootstrap replicates and \code{conf} is the confidence level of the bootstrap calibrated
confidence region.
}
\examples{
\dontrun{
meanYield<-function(x){
 return(mean(x$lai_cowpea))
}
n <- 75
parValues <- data.frame(SoilCN = runif(n, 5, 25),
                 DiffusConst = runif(n, 20, 50), CNCov = runif(n, 0, 1))
apsimExe <-"C:/Program Files (x86)/Apsim75-r3008/Model/Apsim.exe"
apsimWd <- "~/APSIM"
apsimVars <- c("SoilOrganicMatter/SoilCN", "SoilWater/DiffusConst", "SoilWater/CNCov")
apsimFile <- "Canopy.apsim"
emulRes <- apsim_emul_sa(model = apsim_vector, X = parValues, method = "singleGAM",
             exe = apsimExe, wd = apsimWd, vars = apsimVars, to.run = apsimFile,
             g = meanYield, overwrite = TRUE)
plot(emulRes)

}
}

