% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hat_values-fit.R
\name{apd_hat_values}
\alias{apd_hat_values}
\alias{apd_hat_values.default}
\alias{apd_hat_values.data.frame}
\alias{apd_hat_values.matrix}
\alias{apd_hat_values.formula}
\alias{apd_hat_values.recipe}
\title{Fit a \code{apd_hat_values}}
\usage{
apd_hat_values(x, ...)

\method{apd_hat_values}{default}(x, ...)

\method{apd_hat_values}{data.frame}(x, ...)

\method{apd_hat_values}{matrix}(x, ...)

\method{apd_hat_values}{formula}(formula, data, ...)

\method{apd_hat_values}{recipe}(x, data, ...)
}
\arguments{
\item{x}{Depending on the context:
\itemize{
\item A \strong{data frame} of predictors.
\item A \strong{matrix} of predictors.
\item A \strong{recipe} specifying a set of preprocessing steps
created from \code{\link[recipes:recipe]{recipes::recipe()}}.
}}

\item{...}{Not currently used, but required for extensibility.}

\item{formula}{A formula specifying the predictor terms on the right-hand
side. No outcome should be specified.}

\item{data}{When a \strong{recipe} or \strong{formula} is used, \code{data} is specified as:
\itemize{
\item A \strong{data frame} containing the predictors.
}}
}
\value{
A \code{apd_hat_values} object.
}
\description{
\code{apd_hat_values()} fits a model.
}
\examples{
predictors <- mtcars[, -1]

# Data frame interface
mod <- apd_hat_values(predictors)

# Formula interface
mod2 <- apd_hat_values(mpg ~ ., mtcars)

# Recipes interface
library(recipes)
rec <- recipe(mpg ~ ., mtcars)
rec <- step_log(rec, disp)
mod3 <- apd_hat_values(rec, mtcars)

}
