% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_conditionals.R
\name{apollo_conditionals}
\alias{apollo_conditionals}
\title{Calculates conditionals}
\usage{
apollo_conditionals(model, apollo_probabilities, apollo_inputs)
}
\arguments{
\item{model}{Model object. Estimated model object as returned by function \link{apollo_estimate}.}

\item{apollo_probabilities}{Function. Returns probabilities of the model to be estimated. Must receive three arguments:
\itemize{
  \item \strong{\code{apollo_beta}}: Named numeric vector. Names and values of model parameters.
  \item \strong{\code{apollo_inputs}}: List containing options of the model. See \link{apollo_validateInputs}.
  \item \strong{\code{functionality}}: Character. Can be either \strong{\code{"components"}}, \strong{\code{"conditionals"}}, \strong{\code{"estimate"}} (default), \strong{\code{"gradient"}}, \strong{\code{"output"}}, \strong{\code{"prediction"}}, \strong{\code{"preprocess"}}, \strong{\code{"raw"}}, \strong{\code{"report"}}, \strong{\code{"shares_LL"}}, \strong{\code{"validate"}} or \strong{\code{"zero_LL"}}.
}}

\item{apollo_inputs}{List grouping most common inputs. Created by function \link{apollo_validateInputs}.}
}
\value{
Depends on whether the model uses continuous mixtures or latent class.
        \itemize{
          \item If the model contains a continuous mixture, the function returns a list of matrices. 
                Each matrix has dimensions nIndiv x 3. One matrix per random component.
                Each row of each matrix contains the indivID of an individual, and the
                posterior mean and s.d. of this random component for this individual.
          \item If the model contains latent classes, the function returns a matrix with 
                the posterior class allocation probabilities for each individual.
          \item If the model contains both continuous mixtures and latent classes,
                the function fails.
        }
}
\description{
Calculates posterior expected values (conditionals) of random coefficient models (continuous or discrete mixtures/latent class)
}
\details{
This functions is only meant for use with models using either continuous distributions or latent classes, not both at the same time
}
