% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_deltaMethod.R
\name{apollo_deltaMethod}
\alias{apollo_deltaMethod}
\title{Delta method}
\usage{
apollo_deltaMethod(model, deltaMethod_settings)
}
\arguments{
\item{model}{Model object. Estimated model object as returned by function \link{apollo_estimate}.}

\item{deltaMethod_settings}{List of arguments. It must contain the following.
\itemize{
  \item operation: Character. Function to calculate the delta method for. See details.
  \item parName1: Character. Name of the first parameter.
  \item parName2: Character. Name of the second parameter. Optional depending on \code{operation}.
  \item multPar1: Numeric scalar. A value to scale \code{parName1}.
  \item multPar2: Numeric scalar. A value to scale \code{parName2}.
}}
}
\value{
Matrix contating calue, s.e. and t-ratio resulting from the operation. This is also printed to screen.
}
\description{
Applies the delta method to calculate the standard errors of transformations of parameters.
If the bootstrap covariance matrix is available, it is used. If not, the robust covariance matrix is used.
}
\details{
\code{apollo_deltaMethod} supports the following five operations.
\describe{
  \item{sum}{Calculates the s.e. of \code{parName1} + \code{parName2}}
  \item{diff}{Calculates the s.e. of \code{parName1} - \code{parName2} and \code{parName2} - \code{parName1}}
  \item{ratio}{Calculates the s.e. of \code{parName1}/\code{parName2} and \code{parName2}/\code{parName1}}
  \item{exp}{Calculates the s.e. of \code{exp(parName1)}}
  \item{logistic}{If only \code{parName1} is provided, it calculates the s.e. of
        \code{exp(parName1)/(1+exp(parName1))} and \code{1/(1+exp(parName1))}.
        If \code{parName1} and \code{parName2} are provided, it calculates
        \code{exp(par_i)/(1+exp(parName1)+exp(parName2))} for i=1, 2, and 3 (par_3 = 1).}
  \item{lognormal}{Calculates the mean and s.d. of a lognormal distribution based on the mean (\code{parName1}) and s.d. (\code{parName2}) of the underlying normal.}
}
}
