% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_fitsTest.R
\name{apollo_fitsTest}
\alias{apollo_fitsTest}
\title{Compares fit of model across categories}
\usage{
apollo_fitsTest(model, apollo_probabilities, apollo_inputs,
  fitsTest_settings)
}
\arguments{
\item{model}{Model object. Estimated model object as returned by function \link{apollo_estimate}.}

\item{apollo_probabilities}{Function. Returns probabilities of the model to be estimated. Must receive three arguments:
\itemize{
  \item apollo_beta: Named numeric vector. Names and values of model parameters.
  \item apollo_inputs: List containing options of the model. See \link{apollo_validateInputs}.
  \item functionality: Character. Can be either "estimate" (default), "prediction", "validate", "conditionals", "zero_LL", or "raw".
}}

\item{apollo_inputs}{List grouping most common inputs. Created by function \link{apollo_validateInputs}.}

\item{fitsTest_settings}{List of arguments. It must contain the following elements.
\itemize{
     \item subsamples: Named list of boolean vectors. Each element of the list defines whether a given observation belongs to a given subsample (e.g. by sociodemographics).
     \item modelComponent: Name of model component. Set to model by default.
}}
}
\value{
Matrix with average fit per category (invisibly).
}
\description{
Given the predictions of a model, it compares the fit across categories of observations.
}
\details{
Prints a table comparing the average fit for each category.
}
