% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_validateHBcontrol.R
\name{apollo_validateHBcontrol}
\alias{apollo_validateHBcontrol}
\title{Validates the HB_control list of parameters}
\usage{
apollo_validateHBcontrol(HB_control, hb_dist, theta_start, theta_fixed)
}
\arguments{
\item{HB_control}{List. Contains options for bayesian estimation. See \code{?RSGHB::doHB} for details.
Parameters \code{modelname}, \code{gVarNamesFixed}, \code{gVarNamesNormal},
\code{gDIST}, \code{svN} and \code{FC} are automatically set based on the
other arguments of this function.}

\item{hb_dist}{Numeric vector. Contains a number representing the distribution of each
parameter to be estimated. Possible values are as follows.
\describe{
  \item{-1}{Fixed (as in non-random) parameter.}
  \item{1}{Normal.}
  \item{2}{Positive log-normal.}
  \item{3}{Negative log-normal.}
  \item{4}{Positive censored normal.}
  \item{5}{Negative censored normal.}
  \item{6}{Johnson SB.}
}}

\item{theta_start}{Named numeric vector. Names and starting values of the parameters.}

\item{theta_fixed}{Character vector. Names of the fixed parameters (as in those whose
value is constant throughout estimation).}
}
\value{
Validated HB_control
}
\description{
Validates the HB_control list of parameters and sets default values for the omitted ones.
}
\details{
This function is only necessary when using bayesian estimation.
}
