% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\docType{methods}
\name{accessors}
\alias{accessors}
\alias{getLocusNames}
\alias{getLocusNames,multidna}
\alias{getLocusNames,multidna-method}
\alias{getLocusNames,multiphyDat}
\alias{getLocusNames,multiphyDat-method}
\alias{getNumInd}
\alias{getNumInd,multidna-method}
\alias{getNumInd,multiphyDat}
\alias{getNumInd,multiphyDat-method}
\alias{getNumLoci}
\alias{getNumLoci,multidna}
\alias{getNumLoci,multidna-method}
\alias{getNumLoci,multiphyDat}
\alias{getNumLoci,multiphyDat-method}
\alias{getNumSequences}
\alias{getNumSequences,multidna}
\alias{getNumSequences,multidna-method}
\alias{getNumSequences,multiphyDat}
\alias{getNumSequences,multiphyDat-method}
\alias{getSequenceNames}
\alias{getSequenceNames,multidna}
\alias{getSequenceNames,multidna-method}
\alias{getSequenceNames,multiphyDat}
\alias{getSequenceNames,multiphyDat-method}
\alias{getSequences}
\alias{getSequences,multidna}
\alias{getSequences,multidna-method}
\alias{getSequences,multiphyDat}
\alias{getSequences,multiphyDat-method}
\alias{setLocusNames<-}
\alias{setLocusNames<-,multidna}
\alias{setLocusNames<-,multidna-method}
\alias{setLocusNames<-,multiphyDat}
\alias{setLocusNames<-,multiphyDat-method}
\title{multidna Accessors}
\usage{
getNumInd(x, ...)

\S4method{getNumInd}{multidna}(x, ...)

\S4method{getNumInd}{multiphyDat}(x, ...)

getNumLoci(x, ...)

\S4method{getNumLoci}{multidna}(x, ...)

\S4method{getNumLoci}{multiphyDat}(x, ...)

getLocusNames(x, ...)

\S4method{getLocusNames}{multidna}(x, ...)

\S4method{getLocusNames}{multiphyDat}(x, ...)

setLocusNames(x) <- value

\S4method{setLocusNames}{multidna}(x) <- value

\S4method{setLocusNames}{multiphyDat}(x) <- value

getNumSequences(x, ...)

\S4method{getNumSequences}{multidna}(x, exclude.gap.only = TRUE,
  loci = NULL, ...)

\S4method{getNumSequences}{multiphyDat}(x, exclude.gap.only = TRUE,
  loci = NULL, ...)

getSequenceNames(x, ...)

\S4method{getSequenceNames}{multidna}(x, exclude.gap.only = TRUE,
  loci = NULL, ...)

\S4method{getSequenceNames}{multiphyDat}(x, exclude.gap.only = TRUE,
  loci = NULL, ...)

getSequences(x, ...)

\S4method{getSequences}{multidna}(x, loci = NULL, ids = NULL,
  simplify = TRUE, exclude.gap.only = TRUE, ...)

\S4method{getSequences}{multiphyDat}(x, loci = NULL, ids = NULL,
  simplify = TRUE, exclude.gap.only = TRUE, ...)
}
\arguments{
\item{x}{a \linkS4class{multidna} or \linkS4class{multiphyDat} object.}

\item{...}{further arguments passed on to other functions.}

\item{value}{a replacement value for the slot.}

\item{exclude.gap.only}{logical. Remove or ignore sequences containing all gaps?}

\item{loci}{a character, numeric, or logical vector identifying which
loci to return.}

\item{ids}{a character, numeric, or logical vector identifying which
sequences to return within a locus.}

\item{simplify}{logical. If \code{FALSE}, always return a list of
DNAbin sequences. If \code{TRUE} and only one locus has been requested,
return a single DNAbin object.}
}
\description{
Accessors for slots in \linkS4class{multidna} and \linkS4class{multiphyDat} objects.
}
\details{
\describe{
  \item{getNumInd}{Returns the number of individuals.}
  \item{getNumLoci}{Returns the number of loci.}
  \item{getLocusNames}{Returns the names of each locus.}
  \item{setLocusNames}{Sets the names of each locus.}
  \item{getNumSequences}{Returns the number of sequences in each locus.}
  \item{getSequenceNames}{Returns the names of individual sequences at each
    locus.}
  \item{getSequences}{Returns sequences of specified loci and individuals.}
}
}

