% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apaTable.R
\name{apa.table}
\alias{apa.table}
\title{Generic method to generate an APA style table for MS Word}
\usage{
apa.table(data = data.frame(), level1.header = NULL,
  level1.colspan = NULL, level2.header = NULL, number = "XX",
  title = "APA Table", filename = "APA Table.docx", note = NULL,
  landscape = FALSE, save = TRUE)
}
\arguments{
\item{data}{Dataset with statistics.}

\item{level1.header}{The column names for the first header in the table.}

\item{level1.colspan}{(optional) The colspan for the first header column.}

\item{level2.header}{(optional) The column names for the second header in the table.}

\item{number}{(optional) The table number in the document.}

\item{title}{(optional) Name of the table.}

\item{filename}{(optional) Specify the filename (including valid '\code{.docx}' extension).}

\item{note}{(optional) Add a footnote to the bottom of the table.}

\item{landscape}{(optional) Set (\code{TRUE}) if the table should be generated in landscape mode.}

\item{save}{(optional) Set (\code{FALSE}) if the table should not be saved in a document.}
}
\value{
\code{apa.table} object; a list consisting of
\item{succes}{message in case of an error}
\item{save}{flag which indicates whether the document is saved}
\item{table}{\code{FlexTable {ReporteRs}} object}
}
\description{
Generic method to generate an APA style table for MS Word
}
\details{
This method can generate tables with two headers. If two headers are required, it is necesary to
specifify the colspan for the upper level (\code{level1.colspan}). If only one header is required
only the header items need to be specified for \code{level1.header}, and \code{level1.colspan} and
\code{level2.header} do not need be specified.

This method allows users to specify a column in which either the level of significance (header:
\code{"*"}), or a subscript (header: \code{"_"}) is given. For example, when there is a column
with a F-value and there shouldn't be an additional column with the corresponding p-values, it
is possible to specify an additional column with significant values (i.e., +p < .10; *p < .05;
**p < .01; ***p < .001) which will be merged as one column in the final table.

Often it is necesary to provide a table with the means from different groups or conditions. Using
the subscript header (\code{"_"}) it is possible to supply a column with subscripts which indicates
which means on a row significantly differ from each other.
}
\examples{

# Use apa.table function with a minimum of parameters
# Specify statistics
example <- data.frame(
  c("Column 1", "Column 2", "Column 3"),
  c(3.45, 5.21, 2.64),
  c(1.23, 1.06, 1.12)
)

# Create table
apa.table(data = example, level1.header = c("Variable", "M", "SD"))

# Create a table with two headers
# Specify statistics
example <- data.frame(
  c("Column 1", "Column 2", "Column 3"),
  c(3.45, 5.21, 2.64),
  c(1.23, 1.06, 1.12),
  c(8.22, 25.12, 30.27),
  c("+", "**", "***")
)

# Run method and preview table
apa.table(
  data = example,
  level1.header = c("", "Descriptives", "Inferential"),
  level1.colspan = c(1, 2, 2),
  level2.header = c("Variable", "M", "SD", "t-value", "*")
)$table
}

