% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pod_analysis.R
\name{slope_pod_analysis}
\alias{slope_pod_analysis}
\title{Slope-based POD analysis}
\usage{
slope_pod_analysis(bootstrap_metaregression_obj, lower_interpolation_range,
  upper_interpolation_range, interval_size)
}
\arguments{
\item{bootstrap_metaregression_obj}{the object that contains the bootstrap
metaregression models as a \code{bmr} object.}

\item{lower_interpolation_range}{a \code{numeric} value where the
interpolation should be bounded on the lower end.}

\item{upper_interpolation_range}{a \code{numeric} value where the
interpolation should be bounded on the upper end.}

\item{interval_size}{a \code{numeric} value that specifies how large the
interval should be between each value used for interpolation between
the lower and upper bounds.}
}
\value{
slope_pod a two-column \code{data.frame} object that contains the
concentration (column 1) and the median slope.
}
\description{
This requires lower and upper limits to be specified. This is the function
that calculates the slope as part of the basis for the POD. The slope is
used to identify the lower bound asymptote on the concentration-response
curve.
}
\examples{
bmr_obj <- bootstrap_metaregression(oxybenzone, 15, 100)
slope_pod <- slope_pod_analysis(bmr_obj, 0.0001, 10, 0.1)
}

