% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UPPMethods.R
\docType{methods}
\name{UPP-Methods}
\alias{UPP-Methods}
\alias{upp-methods}
\alias{upp,ANY-method}
\alias{upp,Bertrand-method}
\alias{upp,AIDS-method}
\alias{upp,Auction2ndLogit-method}
\title{Methods For Calculating Upwards Pricing Pressure Index (Bertrand)}
\usage{
\S4method{upp}{Bertrand}(object)

\S4method{upp}{AIDS}(object)

\S4method{upp}{Auction2ndLogit}(object)
}
\arguments{
\item{object}{An instance of one of the classes listed above.}
}
\value{
\code{upp} returns a vector of length k equal to the  net UPP for the
merging parties' products and 0 for all other products.
}
\description{
Calculate the Upwards Pricing Pressure Index
for the products of merging firms playing a differentiated
products Bertrand pricing game.
}
\details{
\code{upp} uses the results from the merger simulation and
calibration to compute the upwards pricing pressure of the merger on
each merging parties' products.
}
\seealso{
\code{\link{upp.bertrand}} calculates net UPP
without the need to first calibrate a demand system and simulate a merger.
}
\keyword{methods}
