% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readInputTS.R
\name{readInputTS}
\alias{readInputTS}
\title{Read Input time series}
\usage{
readInputTS(
  load = NULL,
  thermalAvailabilities = NULL,
  ror = NULL,
  hydroStorage = NULL,
  hydroStorageMaxPower = NULL,
  wind = NULL,
  solar = NULL,
  misc = NULL,
  reserve = NULL,
  linkCapacity = NULL,
  opts = simOptions(),
  timeStep = c("hourly", "daily", "weekly", "monthly", "annual"),
  simplify = TRUE,
  parallel = FALSE,
  showProgress = TRUE
)
}
\arguments{
\item{load}{vector of areas names for which load time series must be read.}

\item{thermalAvailabilities}{vector of areas names for which thermal availabilities of clusters must be read.}

\item{ror}{vector of areas names for which run of river time series must be read.}

\item{hydroStorage}{vector of areas names for which hydrolic storage time series must be read.}

\item{hydroStorageMaxPower}{vector of areas names for which hydrolic storage maximum power time series must be read.}

\item{wind}{vector of areas names for which wind time series must be read}

\item{solar}{vector of areas names for which solar time series must be read}

\item{misc}{vector of areas names for which misc time series must be read}

\item{reserve}{vector of areas names for which reserve time series must be read}

\item{linkCapacity}{vector of links names for which links characteristics time series must be read}

\item{opts}{list of simulation parameters returned by the function
\code{\link{setSimulationPath}}}

\item{timeStep}{Resolution of the data to import: hourly (default), daily,
weekly, monthly or annual.}

\item{simplify}{If TRUE and only one type of output is imported then a
data.table is returned. If FALSE, the result will always be a list of class
"antaresData".}

\item{parallel}{Should the importation be parallelized ? (See details)}

\item{showProgress}{If TRUE the function displays information about the progress of the
importation.}
}
\value{
If \code{simplify = TRUE} and only one type of input is imported
then the result is a data.table with class "antaresDataTable".

Else an object of class "antaresDataList" is returned. It is a list of
data.tables, each element representing one type of element (load, wind,
solar, etc.).
}
\description{
\code{readInputTS} is a function that reads time series from an antares 
project. But contrary to \code{\link{readAntares}}, it only reads time series
stored in the input folder, so it can work in "input" mode.
}
\note{
All parameters expecting a vector of areas or links names also accept the
special value "all". It indicates the function to read the desired time 
series for all areas or links.
}
\examples{
\dontrun{
# Set an antares study in "input" mode. This is useful when one want to
# inspect input time series before running a simulation.
# Note that readAntares do not function in input mode, but readInputTS
# works with any mode.

setSimulationPath("path_to_the_study", "input")

# Read load time series
readInputTS(load = "all")

# Read hydrolic storage and maximum power in the same call:
readInputTS(hydroStorage = "all", hydroStorageMaxPower = "all")

# Use a different time step
myArea <- readInputTS(load= "myArea", timeStep = "monthly")

# Quick plot to visualize the variability of the series
matplot(myArea[, - (1:2), with = FALSE], type = "l")
}

}
\seealso{
\code{\link{setSimulationPath}}, \code{\link{readAntares}}, 
\code{\link{getAreas}}, \code{\link{getLinks}}
}
