% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeVirtualAreas.R
\name{removeVirtualAreas}
\alias{removeVirtualAreas}
\title{Remove virtual areas}
\usage{
removeVirtualAreas(x, storageFlexibility = NULL, production = NULL,
  reassignCosts = FALSE, newCols = TRUE)
}
\arguments{
\item{x}{An object of class \code{antaresDataList} with at least components 
\code{areas} and \code{links}.}

\item{storageFlexibility}{A vector containing the names of the virtual 
storage/flexibility areas.}

\item{production}{A vector containing the names of the virtual production 
areas.}

\item{reassignCosts}{If TRUE, the production costs of the virtual areas are 
reallocated to the real areas they are connected to. If the virtual areas 
are connected to a virtual hub, their costs are first reallocated to the 
hub and then the costs of the hub are reallocated to the real areas.}

\item{newCols}{If \code{TRUE}, new columns containing the production of the virtual
areas are added. If FALSE their production is added to the production of
the real areas they are connected to.}
}
\value{
An \code{antaresDataList} object in which virtual areas have been removed and
data of the real has been corrected. See details for an explanation of the
corrections.
}
\description{
This function removes virtual areas from an \code{antaresDataList} object and
corrects the data for the real areas. The \code{antaresDataList} object 
should contain area and link data to function correctly.
}
\details{
Two types of virtual areas have been defined corresponding to different types
of modeling in Antares and different types of post-treatment to do:
  
\itemize{ 
  \item Flexibility/storage areas are areas created to model 
    pumping unit or any other flexibility that behave as a storage. For those 
    virtual areas, the important results are flows on the links. 
  \item Production areas are areas created to isolate some generation from 
    the "real" areas. They can be isolate for several reasons: to distinguish 
    time-series (for example wind onshore/offshore), to select some specific 
    unit to participate to day-ahead reserve, etc.
}
  
\code{removeVirtualAreas} performs different corrections:
  
\itemize{ 
  \item Correct the balance of the real areas by removing the flows
    to or from virtual areas.
  
  \item If parameter \code{reassignCosts} is TRUE, then the costs of the 
    virtual areas are reassigned to the real areas they are connected to. The
    affected columns are \code{OV. COST}, \code{OP. COST}, \code{CO2 EMIS.}
    and \code{NP COST}. If a virtual area is connected to a single real area,
    all its costs are attributed to the real area. If it is connected to
    several real areas, then costs at a given time step are divided between
    them proportionally to the flows between them and the virtual area.
  
  \item For each storage/flexibility area, a column named like the area is 
    created. It contains the values of the flow between the virtual area and 
    the real areas. This column is interpreted as a production of
    electricity: it is positive if the flow from the virtual area to the real
    area is positive and negative otherwise. If parameter \code{newCols} is
    \code{FALSE}, the values are added to the variable \code{PSP} and the 
    columns is removed.
    
  \item If the parameter \code{production} is specified, then the non null
    productions of the virtual areas are either added to the ones of the real 
    areas they are connected to if \code{newCols = FALSE} or put in new 
    columns if \code{newCols = TRUE}. In the second case the columns are 
    named \code{*_virtual} where "\code{*}" is a type of 
    production (wind, solar, nuclear, ...). Productions that are zero for
    all virtual areas are omited.
    If virtual production areas contains clusters then they will be move to the
    real area. 
  
  \item Finally, virtual areas and the links connected to them are removed
    from the data. 
}
  
The functions makes a few assumptions about the network. if they are
violated it will not act correctly: 
  
\itemize{ 
  \item storage/flexibility
    areas can be connected to other storage/flexibility areas (hubs), but at 
    least one of them is connected to a real area. That means that there is
    no group of virtual areas disconnected from the real network. If such a
    group exists, you can either remove them manually or simply not import
    them.
  \item production areas are connected to one and only one real area. They
    cannot be connected to virtual areas. But a real area may by connected to
    several production areas.
}
}
\examples{
\dontrun{

# Assume we have a network with two virtual areas acting as pump storage and
# an area representing offshore production
#
#  offshore
#     |
# real area - psp in
#           \\
#             psp out
#

data <- readAntares(areas="all", links="all")

# Remove pump storage virtual areas

correctedData <- removeVirtualAreas(data, 
                                    storageFlexibility = c("psp in", "psp out"),
                                    production = "offshore")
}

}
