#!/bin/env Rscript                                                         

# {{{ Copyright (c) 2009, Romain Francois <francoisromain@free.fr>
#  :tabSize=4:indentSize=4:noTabs=false:folding=explicit:collapseFolds=1:
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License. }}}

# {{{ first find out if we are installing the ant package or if it is already installed
arguments <- commandArgs( TRUE )
installer <- FALSE
test <- arguments %in% "--installer"
if( any( test ) ){
	arguments <- arguments[ !test ]
	installer <- TRUE
}
SEP <- .Platform$path.sep
# }}}

# {{{ ant setup
# {{{ set env variables

# this is only to get JAVA_HOME, see http://tr.im/xHiZ
require( "methods", quietly = TRUE, character.only = TRUE)
require( "rJava", quietly = TRUE, character.only = TRUE)
.jinit()

JAVA_HOME <- .jcall( "java/lang/System", "S", "getProperty", "java.home" ) 
Sys.setenv( "JAVA_HOME" = JAVA_HOME )

ANT_HOME <- if( installer ){
	tools:::file_path_as_absolute( "../apache-ant" )
} else {
	system.file( "apache-ant", package = "ant" )
}
Sys.setenv( "ANT_HOME" = ANT_HOME )

ANT_LIB <- file.path( ANT_HOME, "lib" )
Sys.setenv( ANT_LIB = ANT_LIB )
# }}}

# {{{ Extract launch and ant arguments, (see details below).
ant_exec_args <- ""
no_config <- FALSE
use_jikes_default <- FALSE
ant_exec_debug <- FALSE
show_help <- FALSE

test <- arguments %in% "--no-config"
if( any(test) ){
	no_config <- TRUE
	arguments <- arguments[ !test ]
}
test <- arguments %in% "--usejikes"
if( any(test) ){
	use_jikes_default <- TRUE
	arguments <- arguments[ !test ]
}
test <- arguments %in% "--execdebug"
if( any(test) ){
	ant_exec_debug <- TRUE
	arguments <- arguments[ !test ]
}
test <- arguments %in% c( "--help", "-help", "-h" )
if( any(test) ){
	show_help <- TRUE
	arguments <- c( "-h", arguments[ !test ] )
}
arguments <- paste( arguments, collapse = " " ) 
# }}}

# {{{ resolve JAVACMD
JAVACMD <- Sys.getenv( "JAVACMD", unset = "" )
if( JAVACMD == "" ){
	# IBM's JDK on AIX uses strange locations for the executables
    if( file.exists( cmd <- file.path( JAVA_HOME, "jre", "sh", "java" ) ) ){
    	JAVACMD <- cmd
    } else if( file.exists( cmd <- file.path( JAVA_HOME, "jre", "bin", "java" ) ) ){
    	JAVACMD <- cmd
    } else if( file.exists( cmd <- file.path( JAVA_HOME, "bin", "java" ) ) ){
    	JAVACMD <- cmd
    }
}
# }}}

# {{{ use launcher to determine LOCALCLASSPATH
LOCALCLASSPATH <- file.path( ANT_LIB, "ant-launcher.jar")
Sys.setenv( LOCALCLASSPATH = LOCALCLASSPATH )
# }}}

# {{{ classpath
# TODO: maybe add the ant-r.jar here
CLASSPATH <- Sys.getenv( "CLASSPATH", unset = "" )
RJAVATOOLS <- system.file( "java", package = "rJava" )
if( CLASSPATH == "" ){
	CLASSPATH <- RJAVATOOLS
} else{
	CLASSPATH <- paste( CLASSPATH, RJAVATOOLS, sep = SEP )
}
# }}}

# {{{ ANT_ARGS
ANT_ARGS <- Sys.getenv( "ANT_ARGS" )
# }}}

# {{{ allow jikes support (off by default)
if( use_jikes_default ){
	ANT_OPTS <- sprintf( "%s -Dbuild.compiler=jikes", Sys.getenv( "ANT_OPTS" ) )
} else {
	ANT_OPTS <- Sys.getenv( "ANT_OPTS" )
}
Sys.setenv( ANT_OPTS = ANT_OPTS )  
# }}}

# {{{ show help if requested
if( show_help ){
  cat( "[script options] [options] [target [target2 [target3] ..]]
  Script Options:
    --help, --h            print this message and ant help
    --usejikes             enable use of jikes by default, unless
                           set explicitly in configuration files
    --execdebug            print ant exec line generated by this
                           launch script\n") 
}
# }}}
# }}}

# {{{ R/rJava/JRI stuff

# {{{ R_HOME
R_HOME <- R.home()
Sys.setenv(R_HOME = R_HOME )
# }}}

# {{{ PATH
Sys.setenv( PATH =
	paste(
		file.path( R.home(), "bin") ,
		file.path( JAVA_HOME, "bin" ) ,
		Sys.getenv('PATH'),
	sep= SEP) )
# }}}

# {{{ LD_LIBRARY_PATH
LD_LIBRARY_PATH <- Sys.getenv( "LD_LIBRARY_PATH", unset = "" )
if( LD_LIBRARY_PATH == "" ){
	LD_LIBRARY_PATH <- Sys.getenv( "JAVA_LIBRARY_PATH", unset = "" )
}
# add JRI
JRI_LD_PATH <- paste(
	system.file( "jri", package = "rJava" ),
	file.path( R_HOME, "lib")
, sep = SEP )
LD_LIBRARY_PATH <- if( LD_LIBRARY_PATH == "" ){
	JRI_LD_PATH
} else {
	paste( LD_LIBRARY_PATH, JRI_LD_PATH, sep = SEP )
}
Sys.setenv( LD_LIBRARY_PATH = LD_LIBRARY_PATH )

# }}}
# }}}

# {{{ make the command
ant_exec_command <- sprintf(
	'"%s" -Djava.library.path="%s" %s -classpath "%s" -Dant.home="%s" -Dant.library.dir="%s" %s org.apache.tools.ant.launch.Launcher -cp "%s" %s', 
	JAVACMD, LD_LIBRARY_PATH, ANT_OPTS, LOCALCLASSPATH, ANT_HOME, ANT_LIB, ANT_ARGS, CLASSPATH, arguments )
if( ant_exec_debug ){
	cat( ant_exec_command , "\n" )
} else{ 
	system( ant_exec_command )
}
# }}}
