% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mahalanobis_distance.R
\name{mahalanobis_distance}
\alias{mahalanobis_distance}
\alias{mahalanobis_distance.matrix}
\alias{mahalanobis_distance.data.frame}
\title{Mahalanobis Distance}
\usage{
mahalanobis_distance(data, output = c("md", "bd", "both"),
  normalize = FALSE)

\method{mahalanobis_distance}{matrix}(data, output = c("md", "bd", "both"),
  normalize = FALSE)

\method{mahalanobis_distance}{data.frame}(data, output = c("md", "bd",
  "both"), normalize = FALSE)
}
\arguments{
\item{data}{A matrix or data frame. Data frames will be converted to matrices
via \code{data.matrix}.}

\item{output}{Character string specifying which distance metric(s) to
compute. Current options include: \code{"md"} for Mahalanobis distance
(default); \code{"bd"} for absolute breakdown distance (used to see which
columns drive the Mahalanobis distance); and \code{"both"} to return both
distance metrics.}

\item{normalize}{Logical indicating whether or not to normalize the breakdown
distances within each column (so that breakdown distances across columns can
be compared).}
}
\value{
If \code{output = "md"}, then a vector containing the Mahalanobis
distances is returned. Otherwise, a matrix.
}
\description{
Calculates the distance between the elements in a data set and the mean
vector of the data for outlier detection. Values are independent of the scale
between variables.
}
\examples{
\dontrun{
# Simulate some data
x <- data.frame(C1 = rnorm(100), C2 = rnorm(100), C3 = rnorm(100))

# Add Mahalanobis distances
x \%>\% dplyr::mutate(MD = mahalanobis_distance(x))

# Add Mahalanobis and breakdown distances
x \%>\% cbind(mahalanobis_distance(x, output = "both"))

# Add Mahalanobis and normalized breakdown distances
x \%>\% cbind(mahalanobis_distance(x, output = "both", normalize = TRUE))
}
}
\references{
W. Wang and R. Battiti, "Identifying Intrusions in Computer Networks with
Principal Component Analysis," in First International Conference on
Availability, Reliability and Security, 2006.
}
