% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/z_pages.R
\name{animint2pages}
\alias{animint2pages}
\title{Publish a list of ggplots as interactive visualizations on a GitHub repository}
\usage{
animint2pages(
  plot.list,
  github_repo,
  commit_message = "Commit from animint2pages",
  private = FALSE,
  required_opts = c("title", "source"),
  ...
)
}
\arguments{
\item{plot.list}{A named list of ggplots and option lists.}

\item{github_repo}{The name of the GitHub repository to which the
files will be pushed.}

\item{commit_message}{A string specifying the commit message for
the pushed files.}

\item{private}{A logical flag indicating whether the GitHub
repository should be private or not (default FALSE).}

\item{required_opts}{Character vector of plot.list element names
which are checked (stop with an error if not present). Use
required_opts=NULL to skip check.}

\item{...}{Additional options passed onto \code{animint2dir}.}
}
\value{
The function returns the initialized GitHub repository object.
}
\description{
This function takes a named list of ggplots, generates interactive animations,
and pushes the generated files to a specified GitHub repository. You can
choose to keep the repository private or public.
Before using this function set your appropriate git 'user.username' and 'user.email'
}
\examples{
\dontrun{
library(animint2)
p1 <- ggplot(mtcars, aes(x = mpg, y = wt)) +
  geom_point()
p2 <- ggplot(mtcars, aes(x = hp, y = wt)) +
  geom_point()
viz <- list(plot1 = p1, plot2 = p2)
animint2pages(
  viz,
  github_repo = "my_animint2_plots",
  commit_message = "New animint",
  private = TRUE)
}

}
