% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimizeEq.R
\name{selectQdims}
\alias{selectQdims}
\title{Iteratively select active dimensions}
\usage{
selectQdims(E, threshold, mu, Sigma, pn = NULL, method = 1,
  reducedReturn = T, verb = 0, limits = NULL, pmvnorm_usr = pmvnorm)
}
\arguments{
\item{E}{discretization design for the field.}

\item{threshold}{threshold.}

\item{mu}{mean vector.}

\item{Sigma}{covariance matrix.}

\item{pn}{coverage probability function based on \code{threshold}, \code{mu} and \code{Sigma}. If \code{NULL} it is computed.}

\item{method}{integer chosen between \itemize{
\item 0  selects by taking equally spaced indexes in mu;
\item 1  samples from pn;
\item 2  samples from pn*(1-pn);
\item 3  samples from pn adjusting for the distance (tries to explore all modes);
\item 4  samples from pn*(1-pn) adjusting for the distance (tries to explore all modes);
\item 5  samples with uniform probabilities.
}}

\item{reducedReturn}{boolean to select the type of return. See Value for further details.}

\item{verb}{level of verbosity: 0 returns nothing, 1 returns minimal info.}

\item{limits}{numeric vector of length 2 with q_min and q_max. If \code{NULL} initialized at c(10,300)}

\item{pmvnorm_usr}{function to compute core probability on active dimensions. Inputs: \itemize{
\item \code{lower:} the vector of lower limits of length \code{d}.
\item \code{upper:} the vector of upper limits of length \code{d}.
\item \code{mean:} the mean vector of length \code{d}.
\item \code{sigma:} the covariance matrix of dimension \code{d}.
}
returns a the probability value with attribute "error", the absolute error. Default is the function \code{\link[mvtnorm]{pmvnorm}} from the package \code{mvtnorm}.}
}
\value{
If \code{reducedReturn=F} returns a list containing
\itemize{
   \item{\code{indQ}: }{the indices of the active dimensions chosen for \eqn{p_q};}
   \item{\code{pq}: }{the biased estimator \eqn{p_q} with attribute \code{error}, the estimated absolute error;}
   \item{\code{Eq}: }{the points of the design \eqn{E} selected for \eqn{p_q};}
   \item{\code{muEq}: }{the subvector of \code{mu} selected for \eqn{p_q};}
   \item{\code{KEq}: }{the submatrix of \code{Sigma} composed by the indexes selected for \eqn{p_q}.}
}
Otherwise it returns only \code{indQ}.
}
\description{
The function \code{selectQdims} iteratively selects the number of active dimensions and the dimensions themselves for the computation of \eqn{p_q}.
The number of dimensions is increased until \eqn{p_{q}-p_{q-1}} is smaller than the error of the procedure.
}
\references{
Azzimonti, D. and Ginsbourger, D. (2018). Estimating orthant probabilities of high dimensional Gaussian vectors with an application to set estimation. Journal of Computational and Graphical Statistics, 27(2), 255-267. Preprint at \href{https://hal.archives-ouvertes.fr/hal-01289126}{hal-01289126}

Chevalier, C. (2013). Fast uncertainty reduction strategies relying on Gaussian process models. PhD thesis, University of Bern.

Genz, A. (1992). Numerical computation of multivariate normal probabilities. Journal of Computational and Graphical Statistics, 1(2):141--149.
}
