% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_nonstandard_aa.R
\name{remove_nonstandard_aa}
\alias{remove_nonstandard_aa}
\title{Remove non standard amino acids from protein sequences}
\usage{
remove_nonstandard_aa(df)
}
\arguments{
\item{df}{A dataframe which contains protein sequence names as the first column and amino acid sequence as the second column}
}
\value{
a dataframe like the input dataframe but with removed proteins that contained non standard amino acids
}
\description{
This function removes anything that is not one of the 20 standard amino acids in protein sequences
}
\examples{

non_standard_df <- readRDS(system.file("extdata/non_standard_df.rds", package = "ampir"))

# non_standard_df
#       seq_name            seq_aa
# [1] G1P6H5_MYOLU    MALTVRIQAACLLLLLLASLTSYSLLLSQTTQLADLQTQ....
# [2] fake_sequence   MKVTHEUSYR$GXMBIJIDG*M80-\%

remove_nonstandard_aa(non_standard_df)
#       seq_name        seq_aa
# [1] G1P6H5_MYOLU    MALTVRIQAACLLLLLLASLTSYSLLLSQTTQLADLQTQ....
}
