% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasonalCycle.R
\name{seasonalCycle}
\alias{seasonalCycle}
\title{Zonal mean plots of model and reference data}
\usage{
seasonalCycle(long.name, nc.mod, nc.ref, mod.id, ref.id, unit.conv.mod,
  unit.conv.ref, variable.unit, outlier.factor = 1000, plot.width = 6,
  plot.height = 5, outputDir = FALSE, myLevel = 1,
  globalValues = "globalMean")
}
\arguments{
\item{long.name}{A string that gives the full name of the variable, e.g. 'Gross primary productivity'}

\item{nc.mod}{A string that gives the path and name of the netcdf file that contains the model output, e.g. '/home/model_gpp.nc'}

\item{nc.ref}{A string that gives the path and name of the netcdf file that contains the reference data output, e.g. '/home/reference_gpp.nc'}

\item{mod.id}{A string that identifies the source of the reference data set, e.g. 'CLASSIC'}

\item{ref.id}{A string that identifies the source of the reference data set, e.g. 'MODIS'}

\item{unit.conv.mod}{A number that is used as a factor to convert the unit of the model data, e.g. 86400}

\item{unit.conv.ref}{A number that is used as a factor to convert the unit of the reference data, e.g. 86400}

\item{variable.unit}{A string that gives the final units using LaTeX notation, e.g. 'gC m$^{-2}$ day$^{-1}$'}

\item{outlier.factor}{A number that is used to define outliers, e.g. 10. Outliers are all values that
exceed the interquartile range multiplied by the outlier factor defined here.
180 degrees and FALSE if you want longitudes to range from 0 to 360 degrees}

\item{plot.width}{Number that gives the plot width, e.g. 8}

\item{plot.height}{Number that gives the plot height, e.g. 4}

\item{outputDir}{A string that gives the output directory, e.g. '/home/project/study'. The output will only be written if the user specifies an output directory.}

\item{myLevel}{A number that determines what level of the output netCDF file to use.
This is relevant for files with multiple levels, which applies to soil data.
By default, myLevel is set to 1.}

\item{globalValues}{Either 'globalMean' or 'globalSum'. If set to 'globalMean',
values are averaged across all grid cells. If set to 'globalSum', values are
summed up. The sum is weighted by grid cell area.}
}
\value{
Three plots in PDF format that give the (a) monthly time series, (b)
annual time series, and (c) the climatological mean seasonal cycle of model
and reference data. Concerning the latter, thee bold line presents the mean
and the shaded area gives the total range caused by interannual variability.
}
\description{
This function plots the mean seasonal cycle and corresponding inter-quartile
range of model and reference data.
}
\examples{
library(amber)
library(classInt)
library(doParallel)
library(foreach)
library(Hmisc)
library(latex2exp)
library(ncdf4)
library(parallel)
library(raster)
library(rgdal)
library(rgeos)
library(scico)
library(sp)
library(stats)
library(utils)
library(viridis)
library(xtable)

long.name <- 'Gross primary productivity'
nc.mod <- system.file('extdata/modelRegular', 'gpp_monthly.nc', package = 'amber')
nc.ref <- system.file('extdata/referenceRegular', 'gpp_GBAF_128x64.nc', package = 'amber')
mod.id <- 'CLASSIC' # define a model experiment ID
ref.id <- 'GBAF' # give reference dataset a name
unit.conv.mod <- 86400*1000 # optional unit conversion for model data
unit.conv.ref <- 86400*1000 # optional unit conversion for reference data
variable.unit <- 'gC m$^{-2}$ day$^{-1}$' # unit after conversion (LaTeX notation)
outlier.factor <- 1000

seasonalCycle(long.name, nc.mod, nc.ref, mod.id, ref.id, unit.conv.mod,
unit.conv.ref, variable.unit)
}
