% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_covariates.R
\name{calculate_covariates}
\alias{calculate_covariates}
\title{Calculate covariates wrapper function}
\usage{
calculate_covariates(
  covariate = c("modis", "koppen-geiger", "koeppen-geiger", "koppen", "koeppen", "geos",
    "dummies", "gmted", "sedac_groads", "groads", "roads", "ecoregions", "ecoregion",
    "hms", "smoke", "gmted", "narr", "geos", "sedac_population", "population", "nlcd",
    "merra", "merra2", "gridmet", "terraclimate", "tri", "nei"),
  from,
  locs,
  locs_id = "site_id",
  ...
)
}
\arguments{
\item{covariate}{character(1). Covariate type.}

\item{from}{character. Single or multiple from strings.}

\item{locs}{sf/SpatVector. Unique locations. Should include
a unique identifier field named \code{locs_id}}

\item{locs_id}{character(1). Name of unique identifier.
Default is \code{"site_id"}.}

\item{...}{Arguments passed to each covariate calculation
function.}
}
\value{
Calculated covariates as a data.frame or SpatVector object
}
\description{
The \code{calculate_covariates()} function extracts values at point
locations from a SpatRaster or SpatVector object returned from
\code{process_covariates()}. \code{calculate_covariates()} and the underlying
source-specific covariate functions have been designed to operate on the
processed objects. To avoid errors, \strong{do not edit the processed
SpatRaster or SpatVector objects before passing to
\code{calculate_covariates()}}.
}
\note{
\code{covariate} argument value is converted to lowercase.
}
\examples{
## NOTE: Example is wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
loc <- data.frame(id = "001", lon = -78.90, lat = 35.97)
calculate_covariates(
  covariate = "narr",
  from = narr, # derived from process_covariates() example
  locs = loc,
  locs_id = "id",
  geom = FALSE
)
}
}
\seealso{
\itemize{
\item \code{\link{calculate_modis}}: "modis", "MODIS"
\item \code{\link{calculate_koppen_geiger}}: "koppen-geiger", "koeppen-geiger", "koppen"
\item \code{\link{calculate_ecoregion}}: "ecoregion", "ecoregions"
\item \code{\link{calculate_temporal_dummies}}: "dummies", "Dummies"
\item \code{\link{calculate_hms}}: "hms", "smoke", "HMS"
\item \code{\link{calculate_gmted}}: "gmted", "GMTED"
\item \code{\link{calculate_narr}}: "narr", "NARR"
\item \code{\link{calculate_geos}}: "geos", "geos_cf", "GEOS"
\item \code{\link{calculate_population}}: "population", "sedac_population"
\item \code{\link{calculate_groads}}: "roads", "groads", "sedac_groads"
\item \code{\link{calculate_nlcd}}: "nlcd", "NLCD"
\item \code{\link{calculate_tri}}: "tri", "TRI"
\item \code{\link{calculate_nei}}: "nei", "NEI"
\item \code{\link{calculate_merra2}}: "merra", "MERRA", "merra2", "MERRA2"
\item \code{\link{calculate_gridmet}}: "gridMET", "gridmet"
\item \code{\link{calculate_terraclimate}}: "terraclimate", "TerraClimate"
}
}
\author{
Insang Song
}
