% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{download_sedac_population}
\alias{download_sedac_population}
\title{Download population density data}
\usage{
download_sedac_population(
  data_resolution = "60 minute",
  data_format = c("GeoTIFF", "ASCII", "netCDF"),
  year = "2020",
  directory_to_save = NULL,
  acknowledgement = FALSE,
  download = FALSE,
  remove_command = FALSE,
  unzip = TRUE,
  remove_zip = FALSE,
  hash = FALSE
)
}
\arguments{
\item{data_resolution}{character(1). Available resolutions are 30 second
(approx. 1 km), 2.5 minute (approx. 5 km), 15 minute (approx. 30 km),
30 minute (approx. 55 km), and 60 minute (approx. 110 km).}

\item{data_format}{character(1). Individual year data can be downloaded as
\code{"ASCII"} or \code{"GeoTIFF"}. "all" years is downloaded as \code{"netCDF"}.}

\item{year}{character(1). Available years are \code{2000}, \code{2005}, \code{2010}, \code{2015}, and
\code{2020}, or \code{"all"} for all years.}

\item{directory_to_save}{character(1). Directory to save data. Two
sub-directories will be created for the downloaded zip files ("/zip_files")
and the unzipped shapefiles ("/data_files").}

\item{acknowledgement}{logical(1). By setting \code{TRUE} the
user acknowledges that the data downloaded using this function may be very
large and use lots of machine storage and memory.}

\item{download}{logical(1). \code{FALSE} will generate a *.txt file
containing all download commands. By setting \code{TRUE} the function
will download all of the requested data files.}

\item{remove_command}{logical(1).
Remove (\code{TRUE}) or keep (\code{FALSE})
the text file containing download commands.}

\item{unzip}{logical(1). Unzip zip files. Default is \code{TRUE}.}

\item{remove_zip}{logical(1). Remove zip files from directory_to_download.
Default is \code{FALSE}.}

\item{hash}{logical(1). By setting \code{TRUE} the function will return
an \code{rlang::hash_file()} hash character corresponding to the
downloaded files. Default is \code{FALSE}.}
}
\value{
\itemize{
\item For \code{hash = FALSE}, NULL
\item For \code{hash = TRUE}, an \code{rlang::hash_file} character.
\item Zip and/or data files will be downloaded and stored in
respective sub-directories within \code{directory_to_save}.
}
}
\description{
The \code{download_sedac_population()} function accesses and downloads
population density data from \href{https://earthdata.nasa.gov/data/catalog/sedac-ciesin-sedac-gpwv4-apdens-wpp-2015-r11-4.11}{NASA's UN WPP-Adjusted Population Density, v4.11}.
}
\examples{
\dontrun{
download_sedac_population(
  data_resolution = "30 second",
  data_format = "GeoTIFF",
  year = "2020",
  directory_to_save = tempdir(),
  acknowledgement = TRUE,
  download = FALSE, # NOTE: download skipped for examples,
  remove_command = TRUE,
  unzip = FALSE
)
}
}
\references{
\insertRef{data_ciesin2017gpwv4}{amadeus}
}
\author{
Mitchell Manware, Insang Song
}
