% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plot_signposts.R
\name{plot_signposts}
\alias{plot_signposts}
\title{Plot PLOS article-level metrics data.}
\usage{
plot_signposts(input)
}
\arguments{
\item{input}{A data.frame from a search from the \code{\link{alm_signposts}} function}
}
\description{
This can be used in conjuction with the function \code{\link{alm_signposts}}.
}
\details{
Note that DOIs are the unit of replication of each study. When plotting,
if the prefix is common among all DOIs, then just the end of the DOI, the numeric
part is printed to make plots less ugly.
}
\examples{
\dontrun{
# Plot data from a single identifier gives a bar chart
dat <- alm_signposts(doi="10.1371/journal.pone.0029797")
plot_signposts(dat)

# Plot data from many identifiers gives a line chart
dois <- c('10.1371/journal.pone.0001543','10.1371/journal.pone.0040117',
   '10.1371/journal.pone.0029797','10.1371/journal.pone.0039395')
dat <- alm_signposts(doi=dois)
plot_signposts(dat)

# software lagotto instance
urls <- c("https://github.com/najoshi/sickle","https://github.com/lh3/wgsim",
   "https://github.com/jstjohn/SeqPrep")
dat <- alm_signposts(url = urls, api_url = "http://software.lagotto.io/api/v5/articles")
plot_signposts(dat)

# scopus ids
ids <- c(68049122102, 14044251458, 48349097292, 28444460441)
dat <- alm_signposts(scp = ids)
plot_signposts(dat)
}
}
\references{
See a tutorial/vignette for alm at
\url{http://ropensci.org/tutorials/alm_tutorial.html}
}
\seealso{
\code{\link{alm_signposts}}
}

