% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/alm_title.R
\name{alm_title}
\alias{alm_title}
\title{Get title of article by inputting the doi for the article.}
\usage{
alm_title(doi = NULL, pmid = NULL, pmcid = NULL, wos = NULL,
  scp = NULL, url = NULL, key = NULL,
  api_url = "http://alm.plos.org/api/v5/articles", ...)
}
\arguments{
\item{doi}{Digital object identifier for an article in PLoS Journals (character)}

\item{pmid}{PubMed object identifier (numeric)}

\item{pmcid}{PubMed Central object identifier (numeric)}

\item{wos}{Web of Science identifier (character)}

\item{scp}{Scopus identifier (character)}

\item{url}{Canonical URL (character)}

\item{key}{your PLoS API key, either enter, or loads from .Rprofile (character)}

\item{api_url}{API endpoint, defaults to http://alm.plos.org/api/v3/articles (character)}

\item{...}{optional additional curl options (debugging tools mostly)}
}
\value{
Title of article, in xml format.
}
\description{
Get title of article by inputting the doi for the article.
}
\examples{
\dontrun{
alm_title(doi='10.1371/journal.pbio.0000012')
dois <- c('10.1371/journal.pone.0026871','10.1371/journal.pone.0048868',
  	'10.1371/journal.pone.0048705','10.1371/journal.pone.0048731')
alm_title(doi=dois)
}
}
\references{
See a tutorial/vignette for alm at
\url{http://ropensci.org/tutorials/alm_tutorial.html}
}

