% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/alm_events.R
\name{alm_events}
\alias{alm_events}
\title{Retrieve PLoS article-level metrics (ALM) events.}
\usage{
alm_events(doi = NULL, pmid = NULL, pmcid = NULL, wos = NULL,
  scp = NULL, url = NULL, source_id = NULL, publisher_id = NULL,
  compact = TRUE, key = NULL,
  api_url = "http://alm.plos.org/api/v5/articles", ...)
}
\arguments{
\item{doi}{Digital object identifier for an article in PLoS Journals (character)}

\item{pmid}{PubMed object identifier (numeric)}

\item{pmcid}{PubMed Central object identifier (numeric)}

\item{wos}{Web of Science identifier (character)}

\item{scp}{Scopus identifier (character)}

\item{url}{Canonical URL (character)}

\item{source_id}{(character) Name of source to get ALM information for. One source only.
You can get multiple sources via a for loop or lapply-type call.}

\item{publisher_id}{(character) Metrics for articles by a given publisher, using the Crossref
\code{member_id}.}

\item{compact}{(logical) Whether to make output compact or not. If TRUE (default), remove
empty sources.}

\item{key}{(character) Your API key, either enter, or loads from .Rprofile. Only required for
PKP source, not the others.}

\item{api_url}{API endpoint, defaults to http://alm.plos.org/api/v3/articles (character)}

\item{...}{optional additional curl options (debugging tools mostly)}
}
\value{
PLoS altmetrics as data.frame's.
}
\description{
Events are the details of the metrics that are counted related to PLoS papers.
}
\details{
You can only supply one of the parmeters doi, pmid, pmcid, and mendeley.

		Query for as many articles at a time as you like. Though queries are broken
		up in to smaller bits of 30 identifiers at a time.

		If you supply both the days and months parameters, days takes precedence,
		and months is ignored.

		You can get events from many different sources. After calling alm_events,
		then index the output by the data provider you want. The options are:
		bloglines, citeulike, connotea, crossref, nature, postgenomic, pubmed,
		scopus, plos, researchblogging, biod, webofscience, pmc, facebook,
		mendeley, twitter, wikipedia, and scienceseeker.

		Beware that some data source are not parsed yet, so there may be event data
		but it is not provided yet as it is so messy to parse.

   See more info on PLOS's relative metrics event source here
   \url{http://www.plosone.org/static/almInfo#relativeMetrics}
}
\examples{
\dontrun{
# For one article
out <- alm_events(doi="10.1371/journal.pone.0029797")
names(out) # names of sources
# remove those with no data
out <- out[!out \%in\% c("sorry, no events content yet","parser not written yet")]
out[["pmc"]] # get the results for PubMed Central
out[["twitter"]] # get the results for twitter
out[["plos_comments"]] # get the results for PLOS comments, sorta messy
out[c("twitter","crossref")] # get the results for two sources

# Another example
(out <- alm_events(doi="10.1371/journal.pone.0001543"))
# remove those with no data
out <- out[!out \%in\% c("sorry, no events content yet","parser not written yet")]
names(out)
out[['scopus']]
out[['mendeley']]
out[['figshare']]
out[['pubmed']]

# Two doi's
dois <- c('10.1371/journal.pone.0001543','10.1371/journal.pone.0040117')
out <- alm_events(doi=dois)
out[[1]]
out[[2]]
out[[1]][["figshare"]]$events

# Many pmcid's
out <- alm_events(pmcid=c(212692,2082661))
names(out)
out['212692']

# Many pmid's
out <- alm_events(pmid = c(19300479, 19390606, 19343216))
names(out)
out['19390606']

# Specify two specific sources
## You have to do so through lapply, or similar approach
lapply(c("crossref","twitter"),
   function(x) alm_events(doi="10.1371/journal.pone.0035869", source_id=x))

# Figshare data
alm_events(doi="10.1371/journal.pone.0069841", source_id='figshare')

# Datacite data
alm_events("10.1371/journal.pone.0012090", source_id='datacite')

# Reddit data
alm_events("10.1371/journal.pone.0015552", source_id='reddit')

# Wordpress data
alm_events("10.1371/journal.pcbi.1000361", source_id='wordpress')

# Articlecoverage data
alm_events(doi="10.1371/journal.pmed.0020124", source_id='articlecoverage')

# Articlecoveragecurated data
headfoo <- function(x) head(x$articlecoveragecurated$events)
headfoo(alm_events(doi="10.1371/journal.pone.0088278", source_id='articlecoveragecurated'))
headfoo(alm_events(doi="10.1371/journal.pmed.1001587", source_id='articlecoveragecurated'))

# F1000 Prime data
alm_events(doi="10.1371/journal.pbio.1001041", source_id='f1000')
dois <- c('10.1371/journal.pmed.0020124','10.1371/journal.pbio.1001041',
           '10.1371/journal.pbio.0040020')
res <- alm_events(doi = dois, source_id='f1000')
res[[3]]

# by source_id only
alm_events(source_id = "crossref")
alm_events(source_id = "reddit")

# by publisher_id only
alm_events(publisher_id = 340)

# search the software lagotto sever
urls <- c("https://github.com/najoshi/sickle","https://github.com/lh3/wgsim",
   "https://github.com/jstjohn/SeqPrep")
dat <- alm_events(url = urls, api_url = "http://software.lagotto.io/api/v5/articles")
}
}
\references{
See a tutorial/vignette for alm at
\url{http://ropensci.org/tutorials/alm_tutorial.html}
}

