% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MixedEffectsModel.R
\name{MixedEffectsModel}
\alias{MixedEffectsModel}
\title{Create a mixed effects model}
\usage{
MixedEffectsModel(
  response_unit,
  covariate_units,
  predict_ranef,
  predict_fn,
  parameters,
  fixed_only = FALSE,
  descriptors = list(),
  covariate_definitions = list()
)
}
\arguments{
\item{response_unit}{A named list containing one element, with a name representing the response
variable and a value representing the units of the response variable
using the \code{units::as_units} function.}

\item{covariate_units}{A named list containing the covariate specifications, with names
representing the covariate name and the values representing the units of
the coavariate using the \code{units::as_units} function}

\item{predict_ranef}{A function that predicts the random effects, takes any named covariates in
\code{covariate_units} as arguments}

\item{predict_fn}{A function that takes the covariate names as arguments and returns a
prediction of the response variable. This function should be vectorized.}

\item{parameters}{A named list of parameters and their values}

\item{fixed_only}{A boolean value indicating if the model produces predictions using only
fixed effects. This is useful when publications do not provide sufficient
information to predict the random effects.}

\item{descriptors}{An optional named list of descriptors that describe the context of the
allometric model}

\item{covariate_definitions}{An optional named list of custom covariate definitions that will supersede
the definitions given by the variable naming system.}
}
\value{
An instance of MixedEffectsModel
}
\description{
\code{MixedEffectsModel} represents an allometric model that uses fixed and
random effects.
}
\section{Slots}{

\describe{
\item{\code{parameters}}{A named list of parameters and their values}

\item{\code{predict_fn_populated}}{The prediction function populated with the
parameter values}

\item{\code{specification}}{A tibble::tbl_df of the model specification, which are
the parameters and the descriptors together}

\item{\code{predict_ranef}}{The function that predicts the random effects}

\item{\code{predict_ranef_populated}}{The function that predicts the random effects
populated with the fixed effect parameter estimates}

\item{\code{fixed_only}}{A boolean value indicating if the model produces predictions
using only fixed effects}
}}

\examples{
MixedEffectsModel(
  response_unit = list(
    hst = units::as_units("m")
  ),
  covariate_units = list(
    dsob = units::as_units("cm")
  ),
  parameters = list(
    beta_0 = 40.4218,
    beta_1 = -0.0276,
    beta_2 = 0.936
  ),
  predict_ranef = function() {
    list(b_0_i = 0, b_2_i = 0)
  },
  predict_fn = function(dsob) {
    1.37 + (beta_0 + b_0_i) * (1 - exp(beta_1 * dsob)^(beta_2 + b_2_i))
  },
  fixed_only = TRUE
)
}
