% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_lm.R
\name{all_lm}
\alias{all_lm}
\title{Estimates all possible effect estimates using \code{lm}}
\usage{
all_lm(crude, xlist, data, na_omit = TRUE, ...)
}
\arguments{
\item{crude}{An object of \emph{formula} for initial model, generally crude model.
However, additional variables can also be included here as the initial model.}

\item{xlist}{A \emph{vector} of a list of variable names (potential confounding factors).}

\item{data}{\emph{Data frame}.}

\item{na_omit}{Remove all missing values. Default is \code{"na_omit = TRUE"}.}

\item{...}{Further optional arguments.}
}
\value{
A list of all effect estimates.
}
\description{
\code{all_lm} estimates coefficients of a specific variable using
linear models (\code{lm}) with all possible combinations of other variables (potential confounding factors).
}
\examples{
vlist <- c("Age", "Sex", "Income")
all_lm(crude = "BMI ~ Married", xlist = vlist, data = diab_df)
}
\seealso{
\pkg{lm}
}
