% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github.R
\name{get_gh_issue_people}
\alias{get_gh_issue_people}
\title{get_gh_issue_people}
\usage{
get_gh_issue_people(
  org,
  repo,
  exclude_issues = NULL,
  exclude_label = "wontfix",
  exclude_not_planned = TRUE
)
}
\arguments{
\item{org}{Github organisation name for repository}

\item{repo}{Repository within \code{org} for which contributors are to be
extracted}

\item{exclude_issues}{Numbers of any issues (or pull requests) to be excluded
from lists of contributors.}

\item{exclude_label}{Exclude any contributions from issues with specified
label (default = "wontfix"; set to \code{NULL} or empty string to include all
issues).}

\item{exclude_not_planned}{If \code{TRUE} (default), exclude contributions to any
issues closed as "not planned".}
}
\value{
List of (authors, contributors), each as character vector of github
login names.
}
\description{
Extract lists of (1) all authors of, and (2) all contributors to, all github
issues for nominated repository, excluding issues closed as "not planned"
}
\examples{
\dontrun{
get_gh_issue_people (org = "ropenscilabs", repo = "allcontributors")
}
}
\seealso{
Other github: 
\code{\link{get_gh_code_contributors}()},
\code{\link{get_gh_contrib_issue}()},
\code{\link{get_gh_issue_titles}()}
}
\concept{github}
