% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{qlin}
\alias{qlin}
\title{Point corresponding to quantile.
Calculate the \eqn{x} point corresponding to a quantile \eqn{F(x)} using linear interpolation.}
\usage{
qlin(x, y, q)
}
\arguments{
\item{x}{A numeric vector, specifying the \eqn{x} values.}

\item{y}{A numeric vector, specifying the \eqn{F(x)} values.}

\item{q}{A real number between 0 and 1 inclusive, specifying the desired quantile.}
}
\value{
The interpolated quantile, \eqn{x}, corresponding to \eqn{q=F(x)}.
}
\description{
Point corresponding to quantile.
Calculate the \eqn{x} point corresponding to a quantile \eqn{F(x)} using linear interpolation.
}
\examples{
x <- rnorm(100)
y <- pnorm(x)
qlin(x, y, 0.5)
}
