% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kappa4al.R
\name{kappa4al}
\alias{kappa4al}
\alias{kappa4al.default}
\alias{print.kappa4al}
\alias{summary.kappa4al}
\alias{print.summary.kappa4al}
\alias{kappa4al.formula}
\alias{predict.kappa4al}
\title{Sigmoidal curve fitting.}
\usage{
kappa4al(formula, data = list(), lower, upper, q1, q2, tol, maxiter, ...)

\method{kappa4al}{default}(formula, data = list(), lower = c(0, -5, -5),
  upper = c(10, 1, 1), q1, q2, tol = 1e-15, maxiter = 50000, ...)

\method{print}{kappa4al}(x, ...)

\method{summary}{kappa4al}(object, ...)

\method{print}{summary.kappa4al}(x, ...)

\method{kappa4al}{formula}(formula, data = list(), lower = c(0, -5, -5),
  upper = c(10, 1, 1), q1, q2, tol = 1e-15, maxiter = 50000, ...)

\method{predict}{kappa4al}(object, newdata = NULL, ...)
}
\arguments{
\item{formula}{An LHS ~ RHS formula, specifying the linear model to be estimated.}

\item{data}{A data.frame which contains the variables in \code{formula}.}

\item{lower}{A vector of lower constraints for the parameters to be estimated; defaults to c(0, -5, -5).}

\item{upper}{A vector of upper constraints for the parameters to be estimated; defaults to c(10, 1, 1).}

\item{q1, q2}{Numeric vectors, for the lower and upper bounds of the intervals over which arc lengths are to be computed.}

\item{tol}{Error tolerance level; defaults to 1e-15.}

\item{maxiter}{The maximum number of iterations allowed; defaults to 50000.}

\item{...}{Arguments to be passed on to the differential evolution function \code{\link{JDEoptim}}.}

\item{x}{A kappa4al object.}

\item{object}{A kappa4al object.}

\item{newdata}{The data on which the estimated model is to be fitted.}
}
\value{
A generic S3 object with class kappa4al.

kappa4al.default: A list with all components from \code{\link{JDEoptim}}, as well as:
\itemize{
\item intercept: Did the model contain an intercept TRUE/FALSE?
\item coefficients: A vector of estimated coefficients.
\item error: The value of the objective function.
\item fitted.values: A vector of estimated values.
\item residuals: The residuals resulting from the fitted model.
\item call: The call to the function.
\item ALFHat: Arc length segments of the empirical CDF (calculated from data).
\item ALF: Arc length segments of the CDF of the four-parameter kappa distribution (theoretical).
p1: The vector of sample quantiles in the data corresponding to \code{q1}.
p2: The vector of sample quantiles in the data corresponding to \code{q2}.
}

summary.kappa4al: A list of class summary.kappa4al with the following components:
\itemize{
\item call: Original call to the \code{kappa4al} function.
\item coefficients: A vector with parameter estimates.
\item arclengths: A matrix of the arc length segments of the dependent and independent variables that were matched.
\item r.squared: The \eqn{r^{2}} coefficient.
\item sigma: The residual standard error.
\item error: Value of the objective function.
\item residSum: Summary statistics for the distribution of the residuals.
}

print.summary.kappa4al: The object passed to the function is returned invisibly.

predict.kappa4al: A vector of predicted values resulting from the estimated model.
}
\description{
A framework for arc length fitting of the four-parameter kappa sigmoidal function.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: default method for kappa4al.

\item \code{kappa4al}: print method for kappa4al.

\item \code{kappa4al}: summary method for kappa4al.

\item \code{summary.kappa4al}: print method for summary.kappa4al.

\item \code{formula}: formula method for kappa4al.

\item \code{kappa4al}: predict method for kappa4al.
}}

\examples{
k <- kappa4tc(-4, 0, 1)$par
x <- seq(qkappa4(0, 4, 0.4, -4, k), qkappa4(0.7, 4, 0.4, -4, k), length.out=100)
y <- sapply(x, function(i) pkappa4(i, 4, 0.4, -4, k))
kappa4nls.default(y~x, q1=c(0.025, 0.5), q2=c(0.5, 0.975), tol=1e-5)

u <- seq(qkappa4(0.1, 4, 0.4, -4, k), qkappa4(0.8, 4, 0.4, -4, k), length.out=100)
v <- sapply(u, function(i) pkappa4(i, 4, 0.4, -4, k))
al <- kappa4al(y~x, q1=c(0.025, 0.5), q2=c(0.5, 0.975), tol=1e-5)
predict(al, newdata=data.frame(y=v, x=u))

}
