% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{alrKDE}
\alias{alrKDE}
\title{Objective function for KDE arc length matching.}
\usage{
alrKDE(beta, gamma, aly, q1, q2, type)
}
\arguments{
\item{beta}{Vector of regression parameters.}

\item{gamma}{Design matrix.}

\item{aly}{A numerical vector of arc length segments to be matched to (same length as \code{beta}).}

\item{q1}{A vector of points (not quantiles) specifying the lower limit of the arc length segments.}

\item{q2}{A vector of points (not quantiles) specifying the upper limit of the arc length segments.}

\item{type}{An integer specifying the bandwidth selection method, see \code{\link{bw}}.}
}
\value{
Square root of the sum of squared differences between \code{gamma}*\code{beta} and \code{aly} (Eucledian distance).
}
\description{
The arc lengths over specified intervals, in the domain of kernel density estimates, are matched.
}
