% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addBackCalcAKI.R
\name{addBackCalcAKI}
\alias{addBackCalcAKI}
\title{Back Calculation AKI}
\usage{
addBackCalcAKI(
  dataframe,
  lookforward = as.difftime(7, units = "days"),
  add_baseline_creat = FALSE
)
}
\arguments{
\item{dataframe}{patient dataset}

\item{lookforward}{amount of time to look forward after admission before the back-calculation method no longer applies}

\item{add_baseline_creat}{boolean to add the intermediate column generated during calculation}
}
\value{
patient dataset with the back-calculation AKI column added in
}
\description{
Back Calculation AKI
}
\examples{
library(dplyr)
toy <- toy \%>\% rename('patient_id' = 'mrn', 'encounter_id' = 'enc', 'inpatient' = 'inpatient',
'creatinine' = 'creat', 'admission' = 'admission', 'time' = 'time')
toy <- transform(toy, time = as.POSIXct(time, format='\%Y-\%m-\%d \%H:\%M:\%S'),
admission = as.POSIXct(admission, format='\%Y-\%m-\%d \%H:\%M:\%S'))
addBackCalcAKI(toy)

}
